/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.DiscoverySelectorIdentifier;
import org.junit.platform.engine.discovery.DiscoverySelectorIdentifierParser;
import org.junit.platform.engine.discovery.DiscoverySelectors;

@API(status=API.Status.MAINTAINED, since="1.13.3")
public final class IterationSelector
implements DiscoverySelector {
    private final DiscoverySelector parentSelector;
    private final SortedSet<Integer> iterationIndices;

    IterationSelector(DiscoverySelector parentSelector, int ... iterationIndices) {
        this.parentSelector = parentSelector;
        this.iterationIndices = this.toSortedSet(iterationIndices);
    }

    private SortedSet<Integer> toSortedSet(int[] iterationIndices) {
        return Arrays.stream(iterationIndices).boxed().collect(Collectors.collectingAndThen(Collectors.toCollection(TreeSet::new), Collections::unmodifiableSortedSet));
    }

    public DiscoverySelector getParentSelector() {
        return this.parentSelector;
    }

    public SortedSet<Integer> getIterationIndices() {
        return this.iterationIndices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IterationSelector that = (IterationSelector)o;
        return this.parentSelector.equals(that.parentSelector) && this.iterationIndices.equals(that.iterationIndices);
    }

    public int hashCode() {
        return Objects.hash(this.parentSelector, this.iterationIndices);
    }

    public String toString() {
        return new ToStringBuilder(this).append("parentSelector", this.parentSelector).append("iterationIndices", this.iterationIndices).toString();
    }

    @Override
    public Optional<DiscoverySelectorIdentifier> toIdentifier() {
        return this.parentSelector.toIdentifier().map(parentSelectorString -> DiscoverySelectorIdentifier.create("iteration", "%s[%s]".formatted(parentSelectorString, this.formatIterationIndicesAsRanges())));
    }

    private String formatIterationIndicesAsRanges() {
        ArrayList<Range> ranges = new ArrayList<Range>();
        class Range {
            final int start;
            int end;

            Range(int start) {
                this.start = start;
                this.end = start;
            }
        }
        Range current = new Range(this.iterationIndices.first());
        ranges.add(current);
        Iterator iterator = this.iterationIndices.tailSet(current.start + 1).iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (n == current.end + 1) {
                current.end = n;
                continue;
            }
            current = new Range(n);
            ranges.add(current);
        }
        return ranges.stream().map(range -> {
            if (range.start == range.end) {
                return String.valueOf(range.start);
            }
            if (range.start == range.end - 1) {
                return range.start + "," + range.end;
            }
            return range.start + ".." + range.end;
        }).collect(Collectors.joining(","));
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static class IdentifierParser
    implements DiscoverySelectorIdentifierParser {
        public static final String PREFIX = "iteration";
        private static final Pattern PATTERN = Pattern.compile("(?<parentIdentifier>.+)\\[(?<indices>(\\d+)(\\.\\.\\d+)?(\\s*,\\s*(\\d+)(\\.\\.\\d+)?)*)]");

        @Override
        public String getPrefix() {
            return PREFIX;
        }

        public Optional<IterationSelector> parse(DiscoverySelectorIdentifier identifier, DiscoverySelectorIdentifierParser.Context context) {
            Matcher matcher = PATTERN.matcher(identifier.getValue());
            Preconditions.condition(matcher.matches(), "Invalid format: must be IDENTIFIER[INDEX(,INDEX)*]");
            return context.parse(matcher.group("parentIdentifier")).map(parent -> {
                int[] iterationIndices = Arrays.stream(matcher.group("indices").split(",")).flatMapToInt(this::parseIndexDefinition).toArray();
                return DiscoverySelectors.selectIteration(parent, iterationIndices);
            });
        }

        private IntStream parseIndexDefinition(String value) {
            return StringUtils.splitIntoTwo("..", value).map(index -> IntStream.of(Integer.parseInt(index)), (firstIndex, lastIndex) -> IntStream.rangeClosed(Integer.parseInt(firstIndex), Integer.parseInt(lastIndex)));
        }
    }
}

