/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.STABLE, since="1.0")
public final class TestTag
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    public static final Set<String> RESERVED_CHARACTERS = Set.of(",", "(", ")", "&", "|", "!");

    public static boolean isValid(@Nullable String name) {
        if (name == null) {
            return false;
        }
        return !(name = name.strip()).isEmpty() && StringUtils.doesNotContainWhitespace(name) && StringUtils.doesNotContainIsoControlCharacter(name) && TestTag.doesNotContainReservedCharacter(name);
    }

    private static boolean doesNotContainReservedCharacter(String str) {
        return RESERVED_CHARACTERS.stream().noneMatch(str::contains);
    }

    public static TestTag create(String name) throws PreconditionViolationException {
        return new TestTag(name);
    }

    private TestTag(String name) {
        Preconditions.condition(TestTag.isValid(name), () -> "Tag name [%s] must be syntactically valid".formatted(name));
        this.name = name.strip();
    }

    public String getName() {
        return this.name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TestTag)) return false;
        TestTag that = (TestTag)obj;
        if (!Objects.equals(this.name, that.name)) return false;
        return true;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

