/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import org.apiguardian.api.API;
import org.junit.platform.console.shadow.picocli.CommandLine;

@API(status=API.Status.INTERNAL, since="1.14")
public class AnsiColorOptionMixin {
    @CommandLine.Spec(value=CommandLine.Spec.Target.MIXEE)
    CommandLine.Model.CommandSpec commandSpec;
    private boolean disableAnsiColors = System.getenv("NO_COLOR") != null;

    public boolean isDisableAnsiColors() {
        return this.disableAnsiColors;
    }

    @CommandLine.Option(names={"--disable-ansi-colors"}, description={"Disable ANSI colors in output (not supported by all terminals)."})
    public void setDisableAnsiColors(boolean disableAnsiColors) {
        if (disableAnsiColors) {
            this.commandSpec.commandLine().setColorScheme(CommandLine.Help.defaultColorScheme(CommandLine.Help.Ansi.OFF));
        }
        this.disableAnsiColors = disableAnsiColors;
    }
}

