/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.command;

import java.util.Optional;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;

@API(status=API.Status.INTERNAL, since="1.10")
public class CommandResult<T> {
    private final int exitCode;
    private final @Nullable T value;

    public static <T> CommandResult<T> success() {
        return CommandResult.create(0, null);
    }

    public static <T> CommandResult<T> create(int exitCode, @Nullable T value) {
        return new CommandResult<T>(exitCode, value);
    }

    private CommandResult(int exitCode, @Nullable T value) {
        this.exitCode = exitCode;
        this.value = value;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public Optional<T> getValue() {
        return Optional.ofNullable(this.value);
    }
}

