/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ClassTemplateInvocationContext;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.AfterParameterizedClassInvocationMethodInvoker;
import org.junit.jupiter.params.ArgumentSetLifecycleMethod;
import org.junit.jupiter.params.BeforeClassTemplateInvocationFieldInjector;
import org.junit.jupiter.params.BeforeParameterizedClassInvocationMethodInvoker;
import org.junit.jupiter.params.ClassTemplateConstructorParameterResolver;
import org.junit.jupiter.params.InstancePostProcessingClassTemplateFieldInjector;
import org.junit.jupiter.params.ParameterizedClassContext;
import org.junit.jupiter.params.ParameterizedInvocationContext;
import org.junit.jupiter.params.ParameterizedInvocationNameFormatter;
import org.junit.jupiter.params.ResolutionCache;
import org.junit.jupiter.params.ResolverFacade;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.platform.commons.util.Preconditions;

class ParameterizedClassInvocationContext
extends ParameterizedInvocationContext<ParameterizedClassContext>
implements ClassTemplateInvocationContext {
    private final ResolutionCache resolutionCache = ResolutionCache.enabled();

    ParameterizedClassInvocationContext(ParameterizedClassContext classContext, ParameterizedInvocationNameFormatter formatter, Arguments arguments, int invocationIndex) {
        super(classContext, formatter, arguments, invocationIndex);
    }

    @Override
    public String getDisplayName(int invocationIndex) {
        return super.getDisplayName(invocationIndex);
    }

    @Override
    public List<Extension> getAdditionalExtensions() {
        return Stream.concat(Stream.of(this.createParameterInjector()), this.createLifecycleMethodInvokers()).toList();
    }

    @Override
    public void prepareInvocation(ExtensionContext context) {
        super.prepareInvocation(context);
    }

    private Extension createParameterInjector() {
        ParameterizedClassContext.InjectionType injectionType = ((ParameterizedClassContext)this.declarationContext).getInjectionType();
        return switch (injectionType) {
            default -> throw new IncompatibleClassChangeError();
            case ParameterizedClassContext.InjectionType.CONSTRUCTOR -> this.createExtensionForConstructorInjection();
            case ParameterizedClassContext.InjectionType.FIELDS -> this.createExtensionForFieldInjection();
        };
    }

    private ClassTemplateConstructorParameterResolver createExtensionForConstructorInjection() {
        Preconditions.condition(((ParameterizedClassContext)this.declarationContext).getTestInstanceLifecycle() == TestInstance.Lifecycle.PER_METHOD, "Constructor injection is only supported for lifecycle PER_METHOD");
        return new ClassTemplateConstructorParameterResolver((ParameterizedClassContext)this.declarationContext, this.arguments, this.invocationIndex, this.resolutionCache);
    }

    private Extension createExtensionForFieldInjection() {
        ResolverFacade resolverFacade = ((ParameterizedClassContext)this.declarationContext).getResolverFacade();
        TestInstance.Lifecycle lifecycle = ((ParameterizedClassContext)this.declarationContext).getTestInstanceLifecycle();
        return switch (lifecycle) {
            default -> throw new IncompatibleClassChangeError();
            case TestInstance.Lifecycle.PER_CLASS -> new BeforeClassTemplateInvocationFieldInjector(resolverFacade, this.arguments, this.invocationIndex, this.resolutionCache);
            case TestInstance.Lifecycle.PER_METHOD -> new InstancePostProcessingClassTemplateFieldInjector(resolverFacade, this.arguments, this.invocationIndex, this.resolutionCache);
        };
    }

    private Stream<Extension> createLifecycleMethodInvokers() {
        return Stream.concat(((ParameterizedClassContext)this.declarationContext).getBeforeMethods().stream().map(this::createBeforeParameterizedClassInvocationMethodInvoker), ((ParameterizedClassContext)this.declarationContext).getAfterMethods().stream().map(this::createAfterParameterizedClassInvocationMethodInvoker));
    }

    private BeforeParameterizedClassInvocationMethodInvoker createBeforeParameterizedClassInvocationMethodInvoker(ArgumentSetLifecycleMethod method) {
        return new BeforeParameterizedClassInvocationMethodInvoker((ParameterizedClassContext)this.declarationContext, this.arguments, this.invocationIndex, this.resolutionCache, method);
    }

    private AfterParameterizedClassInvocationMethodInvoker createAfterParameterizedClassInvocationMethodInvoker(ArgumentSetLifecycleMethod method) {
        return new AfterParameterizedClassInvocationMethodInvoker((ParameterizedClassContext)this.declarationContext, this.arguments, this.invocationIndex, this.resolutionCache, method);
    }
}

