/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestInstantiationAwareExtension;
import org.junit.jupiter.engine.extension.ExtensionContextInternal;
import org.junit.jupiter.engine.extension.PreInterruptCallbackInvocationFactory;
import org.junit.jupiter.engine.extension.TimeoutConfiguration;
import org.junit.jupiter.engine.extension.TimeoutDuration;
import org.junit.jupiter.engine.extension.TimeoutInvocationFactory;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.ReflectionUtils;

class TimeoutExtension
implements BeforeAllCallback,
BeforeEachCallback,
InvocationInterceptor {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create(Timeout.class);
    private static final String TESTABLE_METHOD_TIMEOUT_KEY = "testable_method_timeout_from_annotation";
    private static final String TESTABLE_METHOD_TIMEOUT_THREAD_MODE_KEY = "testable_method_timeout_thread_mode_from_annotation";
    private static final String GLOBAL_TIMEOUT_CONFIG_KEY = "global_timeout_config";

    TimeoutExtension() {
    }

    @Override
    public TestInstantiationAwareExtension.ExtensionContextScope getTestInstantiationExtensionContextScope(ExtensionContext rootContext) {
        return TestInstantiationAwareExtension.ExtensionContextScope.TEST_METHOD;
    }

    @Override
    public void beforeAll(ExtensionContext context) {
        this.readAndStoreTimeoutSoChildrenInheritIt(context);
    }

    @Override
    public void beforeEach(ExtensionContext context) {
        this.readAndStoreTimeoutSoChildrenInheritIt(context);
    }

    private void readAndStoreTimeoutSoChildrenInheritIt(ExtensionContext context) {
        this.readTimeoutFromAnnotation(context.getElement()).ifPresent(timeout -> context.getStore(NAMESPACE).put(TESTABLE_METHOD_TIMEOUT_KEY, timeout));
        this.readTimeoutThreadModeFromAnnotation(context.getElement()).ifPresent(timeoutThreadMode -> context.getStore(NAMESPACE).put(TESTABLE_METHOD_TIMEOUT_THREAD_MODE_KEY, timeoutThreadMode));
    }

    @Override
    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<@Nullable Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptLifecycleMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultBeforeAllMethodTimeout);
    }

    @Override
    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<@Nullable Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptLifecycleMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultBeforeEachMethodTimeout);
    }

    @Override
    public void interceptTestMethod(InvocationInterceptor.Invocation<@Nullable Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptTestableMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultTestMethodTimeout);
    }

    @Override
    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<@Nullable Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptTestableMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultTestTemplateMethodTimeout);
    }

    @Override
    public <T> T interceptTestFactoryMethod(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        return this.interceptTestableMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultTestFactoryMethodTimeout);
    }

    @Override
    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<@Nullable Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptLifecycleMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultAfterEachMethodTimeout);
    }

    @Override
    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<@Nullable Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptLifecycleMethod(invocation, invocationContext, extensionContext, TimeoutConfiguration::getDefaultAfterAllMethodTimeout);
    }

    private void interceptLifecycleMethod(InvocationInterceptor.Invocation<@Nullable Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, TimeoutProvider defaultTimeoutProvider) throws Throwable {
        TimeoutDuration timeout = this.readTimeoutFromAnnotation(Optional.of(invocationContext.getExecutable())).orElse(null);
        this.intercept(invocation, invocationContext, extensionContext, timeout, defaultTimeoutProvider);
    }

    private Optional<TimeoutDuration> readTimeoutFromAnnotation(Optional<AnnotatedElement> element) {
        return AnnotationSupport.findAnnotation(element, Timeout.class).map(TimeoutDuration::from);
    }

    private Optional<Timeout.ThreadMode> readTimeoutThreadModeFromAnnotation(Optional<AnnotatedElement> element) {
        return AnnotationSupport.findAnnotation(element, Timeout.class).map(Timeout::threadMode);
    }

    private <T> T interceptTestableMethod(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, TimeoutProvider defaultTimeoutProvider) throws Throwable {
        TimeoutDuration timeout = extensionContext.getStore(NAMESPACE).get(TESTABLE_METHOD_TIMEOUT_KEY, TimeoutDuration.class);
        return this.intercept(invocation, invocationContext, extensionContext, timeout, defaultTimeoutProvider);
    }

    private <T> T intercept(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, @Nullable TimeoutDuration explicitTimeout, TimeoutProvider defaultTimeoutProvider) throws Throwable {
        TimeoutConfiguration timeoutConfiguration = this.getGlobalTimeoutConfiguration(extensionContext);
        if (timeoutConfiguration.isTimeoutDisabled()) {
            return invocation.proceed();
        }
        TimeoutDuration timeout = explicitTimeout == null ? this.getDefaultTimeout(defaultTimeoutProvider, timeoutConfiguration) : explicitTimeout;
        return this.decorate(invocation, invocationContext, extensionContext, timeout, timeoutConfiguration).proceed();
    }

    private @Nullable TimeoutDuration getDefaultTimeout(TimeoutProvider defaultTimeoutProvider, TimeoutConfiguration timeoutConfiguration) {
        return ((Optional)defaultTimeoutProvider.apply(timeoutConfiguration)).orElse(null);
    }

    private TimeoutConfiguration getGlobalTimeoutConfiguration(ExtensionContext extensionContext) {
        ExtensionContext root = extensionContext.getRoot();
        return root.getStore(NAMESPACE).computeIfAbsent(GLOBAL_TIMEOUT_CONFIG_KEY, __ -> new TimeoutConfiguration(root), TimeoutConfiguration.class);
    }

    private <T> InvocationInterceptor.Invocation<T> decorate(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext, @Nullable TimeoutDuration timeout, TimeoutConfiguration timeoutConfiguration) {
        if (timeout == null) {
            return invocation;
        }
        Timeout.ThreadMode threadMode = this.resolveTimeoutThreadMode(extensionContext, timeoutConfiguration);
        return new TimeoutInvocationFactory(extensionContext.getRoot().getStore(NAMESPACE)).create(threadMode, new TimeoutInvocationFactory.TimeoutInvocationParameters<T>(invocation, timeout, () -> this.describe(invocationContext, extensionContext), PreInterruptCallbackInvocationFactory.create((ExtensionContextInternal)extensionContext)));
    }

    private Timeout.ThreadMode resolveTimeoutThreadMode(ExtensionContext extensionContext, TimeoutConfiguration timeoutConfiguration) {
        Timeout.ThreadMode annotationThreadMode = this.getAnnotationThreadMode(extensionContext);
        if (annotationThreadMode == null || annotationThreadMode == Timeout.ThreadMode.INFERRED) {
            return timeoutConfiguration.getDefaultTimeoutThreadMode().orElse(Timeout.ThreadMode.SAME_THREAD);
        }
        return annotationThreadMode;
    }

    private @Nullable Timeout.ThreadMode getAnnotationThreadMode(ExtensionContext extensionContext) {
        return extensionContext.getStore(NAMESPACE).get(TESTABLE_METHOD_TIMEOUT_THREAD_MODE_KEY, Timeout.ThreadMode.class);
    }

    private String describe(ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) {
        Method method = invocationContext.getExecutable();
        Optional<Class<?>> testClass = extensionContext.getTestClass();
        if (testClass.isPresent() && invocationContext.getTargetClass().equals(testClass.get())) {
            return "%s(%s)".formatted(method.getName(), ClassUtils.nullSafeToString(method.getParameterTypes()));
        }
        return ReflectionUtils.getFullyQualifiedMethodName(invocationContext.getTargetClass(), method);
    }

    @FunctionalInterface
    private static interface TimeoutProvider
    extends Function<TimeoutConfiguration, Optional<TimeoutDuration>> {
    }
}

