/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.AutoClose;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePreDestroyCallback;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

class AutoCloseExtension
implements TestInstancePreDestroyCallback,
AfterAllCallback {
    private static final Logger logger = LoggerFactory.getLogger(AutoCloseExtension.class);

    AutoCloseExtension() {
    }

    @Override
    public void preDestroyTestInstance(ExtensionContext context) {
        ThrowableCollector throwableCollector = new ThrowableCollector(__ -> false);
        TestInstancePreDestroyCallback.preDestroyTestInstances(context, testInstance -> AutoCloseExtension.closeFields(testInstance.getClass(), testInstance, throwableCollector));
        throwableCollector.assertEmpty();
    }

    @Override
    public void afterAll(ExtensionContext context) {
        ThrowableCollector throwableCollector = new ThrowableCollector(__ -> false);
        AutoCloseExtension.closeFields(context.getRequiredTestClass(), null, throwableCollector);
        throwableCollector.assertEmpty();
    }

    private static void closeFields(Class<?> testClass, @Nullable Object testInstance, ThrowableCollector throwableCollector) {
        Predicate<Field> predicate = testInstance == null ? ModifierSupport::isStatic : ModifierSupport::isNotStatic;
        AnnotationSupport.findAnnotatedFields(testClass, AutoClose.class, predicate, HierarchyTraversalMode.BOTTOM_UP).forEach(field -> throwableCollector.execute(() -> AutoCloseExtension.closeField(field, testInstance)));
    }

    private static void closeField(Field field, @Nullable Object testInstance) throws Exception {
        String methodName = AnnotationSupport.findAnnotation(field, AutoClose.class).orElseThrow().value();
        Class<?> fieldType = field.getType();
        AutoCloseExtension.checkCondition(StringUtils.isNotBlank(methodName), "@AutoClose on field %s must specify a method name.", field);
        AutoCloseExtension.checkCondition(!fieldType.isPrimitive(), "@AutoClose is not supported on primitive field %s.", field);
        AutoCloseExtension.checkCondition(!fieldType.isArray(), "@AutoClose is not supported on array field %s.", field);
        Object fieldValue = ReflectionSupport.tryToReadFieldValue(field, testInstance).get();
        if (fieldValue == null) {
            logger.warn(() -> "Cannot @AutoClose field %s because it is null.".formatted(AutoCloseExtension.getQualifiedName(field)));
        } else {
            AutoCloseExtension.invokeCloseMethod(field, fieldValue, methodName.strip());
        }
    }

    private static void invokeCloseMethod(Field field, Object target, String methodName) throws Exception {
        if (target instanceof AutoCloseable) {
            AutoCloseable closeable = (AutoCloseable)target;
            if ("close".equals(methodName)) {
                closeable.close();
                return;
            }
        }
        Class<?> targetType = target.getClass();
        Method closeMethod = ReflectionSupport.findMethod(targetType, methodName, new Class[0]).orElseThrow(() -> new ExtensionConfigurationException("Cannot @AutoClose field %s because %s does not define method %s().".formatted(AutoCloseExtension.getQualifiedName(field), targetType.getName(), methodName)));
        closeMethod = ReflectionUtils.getInterfaceMethodIfPossible(closeMethod, targetType);
        ReflectionSupport.invokeMethod(closeMethod, target, new Object[0]);
    }

    private static void checkCondition(boolean condition, String messageFormat, Field field) {
        Preconditions.condition(condition, () -> messageFormat.formatted(AutoCloseExtension.getQualifiedName(field)));
    }

    private static String getQualifiedName(Field field) {
        String typeName = field.getDeclaringClass().getCanonicalName();
        if (typeName == null) {
            typeName = field.getDeclaringClass().getTypeName();
        }
        return typeName + "." + field.getName();
    }
}

