/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.List;
import java.util.function.UnaryOperator;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.UniqueId;

class UniqueIdPrefixTransformer
implements UnaryOperator<UniqueId> {
    private final UniqueId oldPrefix;
    private final UniqueId newPrefix;
    private final int oldPrefixLength;

    UniqueIdPrefixTransformer(UniqueId oldPrefix, UniqueId newPrefix) {
        this.oldPrefix = oldPrefix;
        this.newPrefix = newPrefix;
        this.oldPrefixLength = oldPrefix.getSegments().size();
    }

    @Override
    public UniqueId apply(UniqueId uniqueId) {
        Preconditions.condition(uniqueId.hasPrefix(this.oldPrefix), () -> "Unique ID %s does not have the expected prefix %s".formatted(uniqueId, this.oldPrefix));
        List<UniqueId.Segment> oldSegments = uniqueId.getSegments();
        List<UniqueId.Segment> suffix = oldSegments.subList(this.oldPrefixLength, oldSegments.size());
        UniqueId newValue = this.newPrefix;
        for (UniqueId.Segment segment : suffix) {
            newValue = newValue.append(segment);
        }
        return newValue;
    }
}

