/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.MediaType;
import org.junit.jupiter.api.function.ThrowingConsumer;
import org.junit.platform.commons.util.Preconditions;

@FunctionalInterface
@API(status=API.Status.STABLE, since="5.0")
public interface TestReporter {
    public void publishEntry(Map<String, String> var1);

    default public void publishEntry(String key, String value) {
        Preconditions.notBlank(key, "key must not be null or blank");
        Preconditions.notBlank(value, "value must not be null or blank");
        this.publishEntry(Map.of(key, value));
    }

    @API(status=API.Status.STABLE, since="5.3")
    default public void publishEntry(String value) {
        this.publishEntry("value", value);
    }

    @Deprecated(since="5.14", forRemoval=true)
    @API(status=API.Status.DEPRECATED, since="5.14")
    default public void publishFile(Path file, MediaType mediaType) {
        Preconditions.notNull(mediaType, "mediaType must not be null");
        this.publishFile(file, org.junit.jupiter.api.MediaType.parse(mediaType.toString()));
    }

    @API(status=API.Status.MAINTAINED, since="5.14")
    default public void publishFile(Path file, org.junit.jupiter.api.MediaType mediaType) {
        Preconditions.notNull(file, "file must not be null");
        Preconditions.notNull(mediaType, "mediaType must not be null");
        Preconditions.condition(Files.exists(file, new LinkOption[0]), () -> "file must exist: " + String.valueOf(file));
        Preconditions.condition(Files.isRegularFile(file, new LinkOption[0]), () -> "file must be a regular file: " + String.valueOf(file));
        this.publishFile(file.getFileName().toString(), mediaType, (Path path) -> Files.copy(file, path, StandardCopyOption.REPLACE_EXISTING));
    }

    @API(status=API.Status.MAINTAINED, since="5.13.3")
    default public void publishDirectory(Path directory) {
        Preconditions.notNull(directory, "directory must not be null");
        Preconditions.condition(Files.exists(directory, new LinkOption[0]), () -> "directory must exist: " + String.valueOf(directory));
        Preconditions.condition(Files.isDirectory(directory, new LinkOption[0]), () -> "path must represent a directory: " + String.valueOf(directory));
        this.publishDirectory(directory.getFileName().toString(), path -> {
            try (Stream<Path> stream = Files.walk(directory, new FileVisitOption[0]);){
                stream.forEach(source -> {
                    Path destination = path.resolve(directory.relativize((Path)source));
                    try {
                        if (Files.isDirectory(source, new LinkOption[0])) {
                            Files.createDirectories(destination, new FileAttribute[0]);
                        } else {
                            Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to copy files to the output directory", e);
                    }
                });
            }
        });
    }

    @Deprecated(since="5.14", forRemoval=true)
    @API(status=API.Status.DEPRECATED, since="5.14")
    default public void publishFile(String name, MediaType mediaType, ThrowingConsumer<Path> action) {
        Preconditions.notNull(mediaType, "mediaType must not be null");
        this.publishFile(name, org.junit.jupiter.api.MediaType.parse(mediaType.toString()), action);
    }

    @API(status=API.Status.MAINTAINED, since="5.14")
    default public void publishFile(String name, org.junit.jupiter.api.MediaType mediaType, ThrowingConsumer<Path> action) {
        throw new UnsupportedOperationException();
    }

    @API(status=API.Status.MAINTAINED, since="5.13.3")
    default public void publishDirectory(String name, ThrowingConsumer<Path> action) {
        throw new UnsupportedOperationException();
    }
}

