/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.opentest4j.MultipleFailuresError;

class AssertAll {
    private AssertAll() {
    }

    static void assertAll(Executable ... executables) {
        AssertAll.assertAll(null, executables);
    }

    static void assertAll(@Nullable String heading, Executable ... executables) {
        Preconditions.notEmpty(executables, "executables array must not be null or empty");
        Preconditions.containsNoNullElements(executables, "individual executables must not be null");
        AssertAll.assertAll(heading, Arrays.stream(executables));
    }

    static void assertAll(Collection<Executable> executables) {
        AssertAll.assertAll(null, executables);
    }

    static void assertAll(@Nullable String heading, Collection<Executable> executables) {
        Preconditions.notNull(executables, "executables collection must not be null");
        Preconditions.containsNoNullElements(executables, "individual executables must not be null");
        AssertAll.assertAll(heading, executables.stream());
    }

    static void assertAll(Stream<Executable> executables) {
        AssertAll.assertAll(null, executables);
    }

    static void assertAll(@Nullable String heading, Stream<Executable> executables) {
        Preconditions.notNull(executables, "executables stream must not be null");
        List<Throwable> failures = executables.map(executable -> {
            Preconditions.notNull(executable, "individual executables must not be null");
            try {
                executable.execute();
                return null;
            }
            catch (Throwable t) {
                UnrecoverableExceptions.rethrowIfUnrecoverable(t);
                return t;
            }
        }).filter(Objects::nonNull).toList();
        if (!failures.isEmpty()) {
            MultipleFailuresError multipleFailuresError = new MultipleFailuresError(heading, failures);
            failures.forEach(arg_0 -> multipleFailuresError.addSuppressed(arg_0));
            throw multipleFailuresError;
        }
    }
}

