/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.open.xml;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.reporting.FileEntry;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.ClasspathResourceSource;
import org.junit.platform.engine.support.descriptor.CompositeTestSource;
import org.junit.platform.engine.support.descriptor.DirectorySource;
import org.junit.platform.engine.support.descriptor.FileSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.descriptor.PackageSource;
import org.junit.platform.engine.support.descriptor.UriSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.reporting.open.xml.GitInfoCollector;
import org.junit.platform.reporting.open.xml.JUnitFactory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.DocumentWriter;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.NamespaceRegistry;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Attachments;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.CoreFactory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Infrastructure;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Result;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Sources;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.git.GitFactory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.java.JavaFactory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.root.Events;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.root.RootFactory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.Namespace;

@API(status=API.Status.MAINTAINED, since="1.13.3")
public class OpenTestReportGeneratingListener
implements TestExecutionListener {
    static final String ENABLED_PROPERTY_NAME = "junit.platform.reporting.open.xml.enabled";
    static final String GIT_ENABLED_PROPERTY_NAME = "junit.platform.reporting.open.xml.git.enabled";
    private final AtomicInteger idCounter = new AtomicInteger();
    private final Map<UniqueId, String> inProgressIds = new ConcurrentHashMap<UniqueId, String>();
    private DocumentWriter<Events> eventsFileWriter = DocumentWriter.noop();
    private final Path workingDir;
    private @Nullable Path outputDir;

    public OpenTestReportGeneratingListener() {
        this(Path.of(".", new String[0]).toAbsolutePath());
    }

    OpenTestReportGeneratingListener(Path workingDir) {
        this.workingDir = workingDir;
    }

    @Override
    public void testPlanExecutionStarted(TestPlan testPlan) {
        ConfigurationParameters config = testPlan.getConfigurationParameters();
        if (this.isEnabled(config)) {
            NamespaceRegistry namespaceRegistry = NamespaceRegistry.builder(Namespace.REPORTING_CORE).add("e", Namespace.REPORTING_EVENTS).add("git", Namespace.REPORTING_GIT).add("java", Namespace.REPORTING_JAVA).add("junit", JUnitFactory.NAMESPACE, "https://schemas.junit.org/open-test-reporting/junit-1.9.xsd").build();
            this.outputDir = testPlan.getOutputDirectoryCreator().getRootDirectory();
            Path eventsXml = this.outputDir.resolve("open-test-report.xml");
            try {
                this.eventsFileWriter = Events.createDocumentWriter(namespaceRegistry, eventsXml);
                this.reportInfrastructure(config);
            }
            catch (Exception e) {
                throw new JUnitException("Failed to initialize XML events file: " + String.valueOf(eventsXml), e);
            }
        }
    }

    private boolean isEnabled(ConfigurationParameters config) {
        return config.getBoolean(ENABLED_PROPERTY_NAME).orElse(false);
    }

    private boolean isGitEnabled(ConfigurationParameters config) {
        return config.getBoolean(GIT_ENABLED_PROPERTY_NAME).orElse(false);
    }

    private void reportInfrastructure(ConfigurationParameters config) {
        this.eventsFileWriter.append(CoreFactory.infrastructure(), infrastructure -> {
            try {
                String hostName = InetAddress.getLocalHost().getHostName();
                infrastructure.append(CoreFactory.hostName(hostName));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            infrastructure.append(CoreFactory.userName(System.getProperty("user.name"))).append(CoreFactory.operatingSystem(System.getProperty("os.name"))).append(CoreFactory.cpuCores(Runtime.getRuntime().availableProcessors())).append(JavaFactory.javaVersion(System.getProperty("java.version"))).append(JavaFactory.fileEncoding(System.getProperty("file.encoding"))).append(JavaFactory.heapSize(), heapSize -> heapSize.withMax(Runtime.getRuntime().maxMemory()));
            if (this.isGitEnabled(config)) {
                GitInfoCollector.get(this.workingDir).ifPresent(git -> this.addGitInfo((Infrastructure)infrastructure, (GitInfoCollector)git));
            }
        });
    }

    private void addGitInfo(Infrastructure infrastructure, GitInfoCollector git) {
        git.getOriginUrl().ifPresent(gitUrl -> infrastructure.append(GitFactory.repository(), repository -> repository.withOriginUrl((String)gitUrl)));
        git.getBranch().ifPresent(branch -> infrastructure.append(GitFactory.branch(branch)));
        git.getCommitHash().ifPresent(gitCommitHash -> infrastructure.append(GitFactory.commit(gitCommitHash)));
        git.getStatus().ifPresent(statusOutput -> infrastructure.append(GitFactory.status(statusOutput), status -> status.withClean(statusOutput.isEmpty())));
    }

    @Override
    public void testPlanExecutionFinished(TestPlan testPlan) {
        try {
            this.eventsFileWriter.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close XML events file", e);
        }
        finally {
            this.eventsFileWriter = DocumentWriter.noop();
        }
    }

    @Override
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        String id = String.valueOf(this.idCounter.incrementAndGet());
        this.reportStarted(testIdentifier, id);
        this.eventsFileWriter.append(RootFactory.finished(id, Instant.now()), finished -> finished.append(CoreFactory.result(Result.Status.SKIPPED), result -> {
            if (StringUtils.isNotBlank(reason)) {
                result.append(CoreFactory.reason(reason));
            }
        }));
    }

    @Override
    public void executionStarted(TestIdentifier testIdentifier) {
        String id = String.valueOf(this.idCounter.incrementAndGet());
        this.inProgressIds.put(testIdentifier.getUniqueIdObject(), id);
        this.reportStarted(testIdentifier, id);
    }

    private void reportStarted(TestIdentifier testIdentifier, String id) {
        this.eventsFileWriter.append(RootFactory.started(id, Instant.now(), testIdentifier.getDisplayName()), started -> {
            testIdentifier.getParentIdObject().ifPresent(parentId -> started.withParentId(this.inProgressIds.get(parentId)));
            started.append(CoreFactory.metadata(), metadata -> {
                if (!testIdentifier.getTags().isEmpty()) {
                    metadata.append(CoreFactory.tags(), tags -> testIdentifier.getTags().forEach(tag -> tags.append(CoreFactory.tag(tag.getName()))));
                }
                metadata.append(JUnitFactory.uniqueId(testIdentifier.getUniqueId())).append(JUnitFactory.legacyReportingName(testIdentifier.getLegacyReportingName())).append(JUnitFactory.type(testIdentifier.getType()));
            });
            testIdentifier.getSource().ifPresent(source -> started.append(CoreFactory.sources(), sources -> this.addTestSource((TestSource)source, (Sources)sources)));
        });
    }

    private void addTestSource(TestSource source, Sources sources) {
        if (source instanceof CompositeTestSource) {
            CompositeTestSource compositeSource = (CompositeTestSource)source;
            compositeSource.getSources().forEach(it -> this.addTestSource((TestSource)it, sources));
        } else if (source instanceof ClassSource) {
            ClassSource classSource = (ClassSource)source;
            sources.append(JavaFactory.classSource(classSource.getClassName()), element -> classSource.getPosition().ifPresent(filePosition -> element.addFilePosition(filePosition.getLine(), filePosition.getColumn())));
        } else if (source instanceof MethodSource) {
            MethodSource methodSource = (MethodSource)source;
            sources.append(JavaFactory.methodSource(methodSource.getClassName(), methodSource.getMethodName()), element -> {
                String methodParameterTypes = methodSource.getMethodParameterTypes();
                if (methodParameterTypes != null) {
                    element.withMethodParameterTypes(methodParameterTypes);
                }
            });
        } else if (source instanceof ClasspathResourceSource) {
            ClasspathResourceSource classpathResourceSource = (ClasspathResourceSource)source;
            sources.append(JavaFactory.classpathResourceSource(classpathResourceSource.getClasspathResourceName()), element -> classpathResourceSource.getPosition().ifPresent(filePosition -> element.addFilePosition(filePosition.getLine(), filePosition.getColumn())));
        } else if (source instanceof PackageSource) {
            PackageSource packageSource = (PackageSource)source;
            sources.append(JavaFactory.packageSource(packageSource.getPackageName()));
        } else if (source instanceof FileSource) {
            FileSource fileSource = (FileSource)source;
            sources.append(CoreFactory.fileSource(fileSource.getFile()), element -> fileSource.getPosition().ifPresent(filePosition -> element.addFilePosition(filePosition.getLine(), filePosition.getColumn())));
        } else if (source instanceof DirectorySource) {
            DirectorySource directorySource = (DirectorySource)source;
            sources.append(CoreFactory.directorySource(directorySource.getFile()));
        } else if (source instanceof UriSource) {
            UriSource uriSource = (UriSource)source;
            sources.append(CoreFactory.uriSource(uriSource.getUri()));
        }
    }

    @Override
    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        String id = this.inProgressIds.get(testIdentifier.getUniqueIdObject());
        this.eventsFileWriter.append(RootFactory.reported(id, Instant.now()), reported -> reported.append(CoreFactory.attachments(), attachments -> {
            Map<String, String> keyValuePairs = entry.getKeyValuePairs();
            if (keyValuePairs.containsKey("stdout") || keyValuePairs.containsKey("stderr")) {
                OpenTestReportGeneratingListener.attachOutput(attachments, entry.getTimestamp(), keyValuePairs.get("stdout"), "stdout");
                OpenTestReportGeneratingListener.attachOutput(attachments, entry.getTimestamp(), keyValuePairs.get("stderr"), "stderr");
            } else {
                attachments.append(CoreFactory.data(entry.getTimestamp()), data -> keyValuePairs.forEach(data::addEntry));
            }
        }));
    }

    private static void attachOutput(Attachments attachments, LocalDateTime timestamp, @Nullable String content, String source) {
        if (content != null) {
            attachments.append(CoreFactory.output(timestamp), output -> output.withSource(source).withContent(content));
        }
    }

    @Override
    public void fileEntryPublished(TestIdentifier testIdentifier, FileEntry entry) {
        String id = this.inProgressIds.get(testIdentifier.getUniqueIdObject());
        this.eventsFileWriter.append(RootFactory.reported(id, Instant.now()), reported -> reported.append(CoreFactory.attachments(), attachments -> attachments.append(CoreFactory.file(entry.getTimestamp()), file -> {
            file.withPath(Objects.requireNonNull(this.outputDir).relativize(entry.getPath()).toString());
            entry.getMediaType().ifPresent(file::withMediaType);
        })));
    }

    @Override
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        String id = this.inProgressIds.remove(testIdentifier.getUniqueIdObject());
        this.eventsFileWriter.append(RootFactory.finished(id, Instant.now()), finished -> finished.append(CoreFactory.result(this.convertStatus(testExecutionResult.getStatus())), result -> testExecutionResult.getThrowable().ifPresent(throwable -> result.append(JavaFactory.throwable(throwable)))));
    }

    private Result.Status convertStatus(TestExecutionResult.Status status) {
        return switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case TestExecutionResult.Status.FAILED -> Result.Status.FAILED;
            case TestExecutionResult.Status.SUCCESSFUL -> Result.Status.SUCCESSFUL;
            case TestExecutionResult.Status.ABORTED -> Result.Status.ABORTED;
        };
    }
}

