/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.open.xml;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.reporting.open.xml.JUnitFactory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.Namespace;
import org.opentest4j.reporting.tooling.spi.htmlreport.Contributor;
import org.opentest4j.reporting.tooling.spi.htmlreport.KeyValuePairs;
import org.opentest4j.reporting.tooling.spi.htmlreport.Section;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@API(status=API.Status.INTERNAL, since="1.12")
public class JUnitContributor
implements Contributor {
    @Override
    public List<Section> contributeSectionsForTestNode(Contributor.Context context) {
        return JUnitContributor.findChild(context.element(), Namespace.REPORTING_CORE, "metadata").map(metadata -> {
            LinkedHashMap table = new LinkedHashMap();
            JUnitContributor.findChild(metadata, JUnitFactory.NAMESPACE, "type").map(Node::getTextContent).ifPresent(value -> table.put("Type", value));
            JUnitContributor.findChild(metadata, JUnitFactory.NAMESPACE, "uniqueId").map(Node::getTextContent).ifPresent(value -> table.put("Unique ID", value));
            JUnitContributor.findChild(metadata, JUnitFactory.NAMESPACE, "legacyReportingName").map(Node::getTextContent).ifPresent(value -> table.put("Legacy reporting name", value));
            return table;
        }).filter(table -> !table.isEmpty()).map(table -> List.of(Section.builder().title("JUnit metadata").order(15).addBlock(KeyValuePairs.builder().content((Map<String, ? extends String>)table).build()).build())).orElse(Collections.emptyList());
    }

    private static Optional<Node> findChild(Node parent, Namespace namespace, String localName) {
        NodeList children = parent.getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Node child = children.item(i2);
            if (!localName.equals(child.getLocalName()) || !namespace.getUri().equals(child.getNamespaceURI())) continue;
            return Optional.of(child);
        }
        return Optional.empty();
    }
}

