/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.output;

import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestIdentifier;

enum Style {
    NONE,
    SUCCESSFUL,
    ABORTED,
    FAILED,
    SKIPPED,
    CONTAINER,
    TEST,
    DYNAMIC,
    REPORTED;


    static Style valueOf(TestExecutionResult result) {
        return switch (result.getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case TestExecutionResult.Status.SUCCESSFUL -> SUCCESSFUL;
            case TestExecutionResult.Status.ABORTED -> ABORTED;
            case TestExecutionResult.Status.FAILED -> FAILED;
        };
    }

    static Style valueOf(TestIdentifier testIdentifier) {
        return testIdentifier.isContainer() ? CONTAINER : TEST;
    }
}

