/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.annotation.Contract;
import org.junit.platform.commons.util.ClassNamePatternFilterUtils;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="1.0")
public final class ExceptionUtils {
    private static final String JUNIT_PLATFORM_LAUNCHER_PACKAGE_PREFIX = "org.junit.platform.launcher.";
    private static final Predicate<String> STACK_TRACE_ELEMENT_FILTER = ClassNamePatternFilterUtils.excludeMatchingClassNames("org.junit.*,jdk.internal.reflect.*,sun.reflect.*");

    private ExceptionUtils() {
    }

    @Contract(value="_ -> fail")
    public static RuntimeException throwAsUncheckedException(Throwable t) {
        Preconditions.notNull(t, "Throwable must not be null");
        return (RuntimeException)ExceptionUtils.throwAs(t);
    }

    @Contract(value="_ -> fail")
    private static <T extends Throwable> T throwAs(Throwable t) throws T {
        throw t;
    }

    public static String readStackTrace(Throwable throwable) {
        Preconditions.notNull(throwable, "Throwable must not be null");
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            throwable.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }

    @API(status=API.Status.INTERNAL, since="1.10")
    public static void pruneStackTrace(Throwable throwable, List<String> classNames) {
        Preconditions.notNull(throwable, "Throwable must not be null");
        Preconditions.notNull(classNames, "List of class names must not be null");
        List<StackTraceElement> stackTrace = Arrays.asList(throwable.getStackTrace());
        ArrayList<StackTraceElement> prunedStackTrace = new ArrayList<StackTraceElement>();
        Collections.reverse(stackTrace);
        for (int i2 = 0; i2 < stackTrace.size(); ++i2) {
            StackTraceElement element = stackTrace.get(i2);
            String className = element.getClassName();
            if (classNames.contains(className)) {
                prunedStackTrace.clear();
                prunedStackTrace.addAll(stackTrace.subList(i2, stackTrace.size()));
                break;
            }
            if (className.startsWith(JUNIT_PLATFORM_LAUNCHER_PACKAGE_PREFIX)) {
                prunedStackTrace.clear();
                continue;
            }
            if (!STACK_TRACE_ELEMENT_FILTER.test(className)) continue;
            prunedStackTrace.add(element);
        }
        Collections.reverse(prunedStackTrace);
        throwable.setStackTrace(prunedStackTrace.toArray(new StackTraceElement[0]));
    }

    @API(status=API.Status.INTERNAL, since="1.10")
    public static List<Throwable> findNestedThrowables(Throwable rootThrowable) {
        Preconditions.notNull(rootThrowable, "Throwable must not be null");
        LinkedHashSet<Throwable> visited = new LinkedHashSet<Throwable>();
        ArrayDeque<Throwable> toVisit = new ArrayDeque<Throwable>();
        toVisit.add(rootThrowable);
        while (!toVisit.isEmpty()) {
            Throwable current = (Throwable)toVisit.remove();
            boolean isFirstVisit = visited.add(current);
            if (!isFirstVisit) continue;
            Throwable cause = current.getCause();
            if (cause != null) {
                toVisit.add(cause);
            }
            toVisit.addAll(Arrays.asList(current.getSuppressed()));
        }
        return List.copyOf(visited);
    }
}

