/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.AnnotationBasedArgumentsProvider;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.CsvParsingException;
import org.junit.jupiter.params.provider.CsvReaderFactory;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvReader;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvRecord;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.NamedCsvRecord;
import org.junit.jupiter.params.support.ParameterDeclarations;
import org.junit.jupiter.params.support.ParameterNameAndArgument;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.UnrecoverableExceptions;

class CsvArgumentsProvider
extends AnnotationBasedArgumentsProvider<CsvSource> {
    CsvArgumentsProvider() {
    }

    @Override
    protected Stream<? extends Arguments> provideArguments(ParameterDeclarations parameters, ExtensionContext context, CsvSource csvSource) {
        CsvReaderFactory.validate(csvSource);
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        try (CsvReader<? extends CsvRecord> reader = CsvReaderFactory.createReaderFor(csvSource, CsvArgumentsProvider.getData(csvSource));){
            boolean useHeadersInDisplayName = csvSource.useHeadersInDisplayName();
            for (CsvRecord csvRecord : reader) {
                arguments.add(CsvArgumentsProvider.processCsvRecord(csvRecord, useHeadersInDisplayName));
            }
        }
        catch (Throwable throwable) {
            throw CsvArgumentsProvider.handleCsvException(throwable, csvSource);
        }
        return arguments.stream();
    }

    private static String getData(CsvSource csvSource) {
        CharSequence[] values = csvSource.value();
        Preconditions.condition(values.length > 0 ^ !csvSource.textBlock().isEmpty(), () -> "@CsvSource must be declared with either `value` or `textBlock` but not both");
        if (!csvSource.textBlock().isEmpty()) {
            return csvSource.textBlock();
        }
        for (int i2 = 0; i2 < values.length; ++i2) {
            int finalI = i2;
            Preconditions.notBlank((String)values[i2], () -> "CSV record at index %d must not be blank".formatted(finalI + 1));
        }
        return String.join((CharSequence)"\n", values);
    }

    static Arguments processCsvRecord(CsvRecord record, boolean useHeadersInDisplayName) {
        List<String> fields = record.getFields();
        List<Object> headers = useHeadersInDisplayName ? CsvArgumentsProvider.getHeaders(record) : List.of();
        Preconditions.condition(!useHeadersInDisplayName || fields.size() <= headers.size(), () -> "The number of columns (%d) exceeds the number of supplied headers (%d) in CSV record: %s".formatted(fields.size(), headers.size(), fields));
        @Nullable Object[] arguments = new Object[fields.size()];
        for (int i2 = 0; i2 < fields.size(); ++i2) {
            Object argument = CsvArgumentsProvider.resolveNullMarker(fields.get(i2));
            if (useHeadersInDisplayName) {
                String header = CsvArgumentsProvider.resolveNullMarker((String)headers.get(i2));
                argument = new ParameterNameAndArgument(String.valueOf(header), argument);
            }
            arguments[i2] = argument;
        }
        return Arguments.of(arguments);
    }

    private static List<String> getHeaders(CsvRecord record) {
        return ((NamedCsvRecord)record).getHeader();
    }

    private static @Nullable String resolveNullMarker(String record) {
        return record == CsvReaderFactory.DefaultFieldModifier.NULL_MARKER ? null : record;
    }

    static RuntimeException handleCsvException(Throwable throwable, Annotation annotation) {
        UnrecoverableExceptions.rethrowIfUnrecoverable(throwable);
        if (throwable instanceof PreconditionViolationException) {
            PreconditionViolationException exception = (PreconditionViolationException)throwable;
            throw exception;
        }
        throw new CsvParsingException("Failed to parse CSV input configured via " + String.valueOf(annotation), throwable);
    }
}

