/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;

class MethodFinder {
    private static final Pattern METHOD_PATTERN = Pattern.compile("(.+)\\((.*)\\)");

    MethodFinder() {
    }

    Optional<Method> findMethod(String methodSpecPart, Class<?> clazz) {
        Matcher matcher = METHOD_PATTERN.matcher(methodSpecPart);
        Preconditions.condition(matcher.matches(), () -> "Method [%s] does not match pattern [%s]".formatted(methodSpecPart, METHOD_PATTERN));
        String methodName = matcher.group(1);
        String parameterTypeNames = matcher.group(2);
        return ReflectionSupport.findMethod(clazz, methodName, parameterTypeNames);
    }
}

