/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.extension.support;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.STABLE, since="5.10")
public abstract class TypeBasedParameterResolver<T>
implements ParameterResolver {
    private final Type supportedParameterType = this.enclosedTypeOfParameterResolver();

    @Override
    public final boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.supportedParameterType.equals(this.getParameterType(parameterContext));
    }

    public abstract T resolveParameter(ParameterContext var1, ExtensionContext var2) throws ParameterResolutionException;

    private Type getParameterType(ParameterContext parameterContext) {
        return parameterContext.getParameter().getParameterizedType();
    }

    private Type enclosedTypeOfParameterResolver() {
        ParameterizedType typeBasedParameterResolverSuperclass = Preconditions.notNull(this.findTypeBasedParameterResolverSuperclass(this.getClass()), () -> "Failed to discover parameter type supported by %s; potentially caused by lacking parameterized type in class declaration.".formatted(this.getClass().getName()));
        return typeBasedParameterResolverSuperclass.getActualTypeArguments()[0];
    }

    private @Nullable ParameterizedType findTypeBasedParameterResolverSuperclass(Class<?> clazz) {
        ParameterizedType type;
        Type rawType;
        Class<?> superclass = clazz.getSuperclass();
        if (superclass == null || superclass == Object.class) {
            return null;
        }
        Type genericSuperclass = clazz.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType && (rawType = (type = (ParameterizedType)genericSuperclass).getRawType()) == TypeBasedParameterResolver.class) {
            return type;
        }
        return this.findTypeBasedParameterResolverSuperclass(superclass);
    }
}

