/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.ArrayDeque;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.junit.platform.commons.util.Preconditions;

class AssertLinesMatch {
    private static final int MAX_SNIPPET_LENGTH = 21;

    private AssertLinesMatch() {
    }

    static void assertLinesMatch(List<String> expectedLines, List<String> actualLines) {
        AssertLinesMatch.assertLinesMatch(expectedLines, actualLines, null);
    }

    static void assertLinesMatch(List<String> expectedLines, List<String> actualLines, @Nullable String message) {
        AssertLinesMatch.assertLinesMatch(expectedLines, actualLines, (Object)message);
    }

    static void assertLinesMatch(Stream<String> expectedLines, Stream<String> actualLines) {
        AssertLinesMatch.assertLinesMatch(expectedLines, actualLines, null);
    }

    static void assertLinesMatch(Stream<String> expectedLines, Stream<String> actualLines, @Nullable String message) {
        AssertLinesMatch.assertLinesMatch(expectedLines, actualLines, (Object)message);
    }

    static void assertLinesMatch(Stream<String> expectedLines, Stream<String> actualLines, @Nullable Object messageOrSupplier) {
        Preconditions.notNull(expectedLines, "expectedLines must not be null");
        Preconditions.notNull(actualLines, "actualLines must not be null");
        if (expectedLines == actualLines) {
            return;
        }
        List<String> expectedListOfStrings = expectedLines.toList();
        List<String> actualListOfStrings = actualLines.toList();
        AssertLinesMatch.assertLinesMatch(expectedListOfStrings, actualListOfStrings, messageOrSupplier);
    }

    static void assertLinesMatch(List<String> expectedLines, List<String> actualLines, @Nullable Object messageOrSupplier) {
        Preconditions.notNull(expectedLines, "expectedLines must not be null");
        Preconditions.notNull(actualLines, "actualLines must not be null");
        if (expectedLines == actualLines) {
            return;
        }
        new LinesMatcher(expectedLines, actualLines, messageOrSupplier).assertLinesMatch();
    }

    static boolean isFastForwardLine(String line) {
        return (line = line.strip()).length() >= 4 && line.startsWith(">>") && line.endsWith(">>");
    }

    static int parseFastForwardLimit(String fastForwardLine) {
        fastForwardLine = fastForwardLine.strip();
        String text = fastForwardLine.substring(2, fastForwardLine.length() - 2).strip();
        try {
            int limit = Integer.parseInt(text);
            Preconditions.condition(limit > 0, () -> "fast-forward(%d) limit must be greater than zero".formatted(limit));
            return limit;
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }

    static boolean matches(String expectedLine, String actualLine) {
        Preconditions.notNull(expectedLine, "expected line must not be null");
        Preconditions.notNull(actualLine, "actual line must not be null");
        if (expectedLine.equals(actualLine)) {
            return true;
        }
        try {
            return actualLine.matches(expectedLine);
        }
        catch (PatternSyntaxException ignore) {
            return false;
        }
    }

    private record LinesMatcher(List<String> expectedLines, List<String> actualLines, @Nullable Object messageOrSupplier) {
        void assertLinesMatch() {
            int actualSize;
            int expectedSize = this.expectedLines.size();
            if (expectedSize > (actualSize = this.actualLines.size())) {
                this.fail("expected %d lines, but only got %d", expectedSize, actualSize);
            }
            if (expectedSize == actualSize && IntStream.range(0, expectedSize).allMatch(i2 -> AssertLinesMatch.matches(this.expectedLines.get(i2), this.actualLines.get(i2)))) {
                return;
            }
            this.assertLinesMatchWithFastForward();
        }

        void assertLinesMatchWithFastForward() {
            ArrayDeque<String> expectedDeque = new ArrayDeque<String>(this.expectedLines);
            ArrayDeque<String> actualDeque = new ArrayDeque<String>(this.actualLines);
            block0: while (!expectedDeque.isEmpty()) {
                String actualLine;
                String expectedLine = (String)expectedDeque.pop();
                int expectedLineNumber = this.expectedLines.size() - expectedDeque.size();
                if (actualDeque.isEmpty()) {
                    this.fail("expected line #%d:`%s` not found - actual lines depleted", expectedLineNumber, this.snippet(expectedLine));
                }
                if (AssertLinesMatch.matches(expectedLine, actualLine = (String)actualDeque.peek())) {
                    actualDeque.pop();
                    continue;
                }
                if (AssertLinesMatch.isFastForwardLine(expectedLine)) {
                    int fastForwardLimit = AssertLinesMatch.parseFastForwardLimit(expectedLine);
                    int actualRemaining = actualDeque.size();
                    if (expectedDeque.isEmpty()) {
                        if (fastForwardLimit == Integer.MAX_VALUE || fastForwardLimit == actualRemaining) {
                            return;
                        }
                        this.fail("terminal fast-forward(%d) error: fast-forward(%d) expected", fastForwardLimit, actualRemaining);
                    }
                    if (fastForwardLimit != Integer.MAX_VALUE) {
                        if (actualRemaining < fastForwardLimit) {
                            this.fail("fast-forward(%d) error: not enough actual lines remaining (%s)", fastForwardLimit, actualRemaining);
                        }
                        for (int i2 = 0; i2 < fastForwardLimit; ++i2) {
                            actualDeque.pop();
                        }
                        continue;
                    }
                    expectedLine = (String)expectedDeque.peek();
                    while (true) {
                        if (actualDeque.isEmpty()) {
                            this.fail("fast-forward(\u221e) didn't find: `%s`", this.snippet(expectedLine));
                        }
                        if (AssertLinesMatch.matches(expectedLine, (String)actualDeque.peek())) continue block0;
                        actualDeque.pop();
                    }
                }
                int actualLineNumber = this.actualLines.size() - actualDeque.size() + 1;
                this.fail("expected line #%d doesn't match actual line #%d%n\texpected: `%s`%n\t  actual: `%s`", expectedLineNumber, actualLineNumber, expectedLine, actualLine);
            }
            if (!actualDeque.isEmpty()) {
                this.fail("more actual lines than expected: %d", actualDeque.size());
            }
        }

        String snippet(String line) {
            if (line.length() <= 21) {
                return line;
            }
            return line.substring(0, 16) + "[...]";
        }

        void fail(String format, Object ... args) {
            String newLine = System.lineSeparator();
            AssertionFailureBuilder.assertionFailure().message(this.messageOrSupplier).reason(format.formatted(args)).expected(String.join((CharSequence)newLine, this.expectedLines)).actual(String.join((CharSequence)newLine, this.actualLines)).includeValuesInMessage(false).buildAndThrow();
        }
    }
}

