/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXResult;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.AttributeValueEscapingWriter;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.ChildElement;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Context;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.DocumentWriter;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Element;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.EscapingXMLStreamWriter;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Factory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.NamespaceRegistry;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.SingleElementXMLStreamWriter;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.Namespace;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.QualifiedName;

class DefaultDocumentWriter<T extends Element<T>>
implements DocumentWriter<T> {
    private final AttributeValueEscapingWriter out;
    private final XMLStreamWriter xmlWriter;
    private final Context context;
    private final Transformer transformer;
    private final SingleElementXMLStreamWriter elementXmlWriter;

    DefaultDocumentWriter(QualifiedName rootElementName, NamespaceRegistry namespaceRegistry, Writer writer) throws Exception {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.out = new AttributeValueEscapingWriter(DefaultDocumentWriter.buffered(writer));
        this.xmlWriter = new EscapingXMLStreamWriter(this.out, factory.createXMLStreamWriter(this.out));
        this.xmlWriter.writeStartDocument();
        this.writeNewLine();
        this.writeStartElement(rootElementName, namespaceRegistry);
        this.writeNamespaces(namespaceRegistry);
        this.writeSchemaLocations(namespaceRegistry);
        this.xmlWriter.writeCharacters("");
        this.elementXmlWriter = new SingleElementXMLStreamWriter(this.xmlWriter, namespaceRegistry);
        this.context = Context.create(rootElementName, namespaceRegistry);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        this.transformer = transformerFactory.newTransformer();
        this.transformer.setOutputProperty("method", "xml");
    }

    private void writeStartElement(QualifiedName rootElement, NamespaceRegistry namespaceRegistry) throws XMLStreamException {
        Optional<String> prefix = namespaceRegistry.getPrefix(rootElement.getNamespace());
        if (prefix.isPresent()) {
            this.xmlWriter.writeStartElement(prefix.get(), rootElement.getSimpleName(), rootElement.getNamespace().getUri());
        } else {
            this.xmlWriter.writeStartElement(rootElement.getSimpleName());
        }
    }

    private void writeNamespaces(NamespaceRegistry namespaceRegistry) throws XMLStreamException {
        this.xmlWriter.writeDefaultNamespace(namespaceRegistry.getDefaultNamespace().getUri());
        for (Namespace namespace : namespaceRegistry.getAdditionalNamespaces()) {
            Optional<String> prefix = namespaceRegistry.getPrefix(namespace);
            if (!prefix.isPresent()) continue;
            this.xmlWriter.writeNamespace(prefix.get(), namespace.getUri());
        }
    }

    private void writeSchemaLocations(NamespaceRegistry namespaceRegistry) throws XMLStreamException {
        if (!namespaceRegistry.getSchemaLocations().isEmpty()) {
            String value = namespaceRegistry.getSchemaLocations().entrySet().stream().map(e -> ((Namespace)e.getKey()).getUri() + " " + (String)e.getValue()).collect(Collectors.joining(" "));
            this.xmlWriter.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", value);
        }
    }

    private static BufferedWriter buffered(Writer writer) {
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    @Override
    public synchronized <C extends ChildElement<T, ? super C>> DocumentWriter<T> append(Factory<C> creator, Consumer<? super C> configurer) {
        ChildElement event = (ChildElement)creator.createAndConfigure(this.context, configurer);
        try {
            this.writeNewLine();
            org.w3c.dom.Element domElement = event.getDomElement();
            domElement.normalize();
            this.transformer.transform(new DOMSource(domElement), new StAXResult(this.elementXmlWriter));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write event: " + event, e);
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        try {
            this.writeNewLine();
            this.xmlWriter.writeEndDocument();
            this.xmlWriter.close();
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to write XML", e);
        }
        finally {
            this.out.close();
        }
    }

    private void writeNewLine() throws IOException, XMLStreamException {
        this.xmlWriter.flush();
        this.out.newLine();
        this.out.flush();
    }
}

