/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;

@API(status=API.Status.STABLE, since="1.0")
public final class TestIdentifier
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final UniqueId uniqueId;
    private final @Nullable UniqueId parentId;
    private final String displayName;
    private final String legacyReportingName;
    private final @Nullable TestSource source;
    private final Set<TestTag> tags;
    private final TestDescriptor.Type type;

    @API(status=API.Status.INTERNAL, since="1.0")
    public static TestIdentifier from(TestDescriptor testDescriptor) {
        Preconditions.notNull(testDescriptor, "TestDescriptor must not be null");
        UniqueId uniqueId = testDescriptor.getUniqueId();
        String displayName = testDescriptor.getDisplayName();
        TestSource source = testDescriptor.getSource().orElse(null);
        Set<TestTag> tags = testDescriptor.getTags();
        TestDescriptor.Type type = testDescriptor.getType();
        UniqueId parentId = testDescriptor.getParent().map(TestDescriptor::getUniqueId).orElse(null);
        String legacyReportingName = testDescriptor.getLegacyReportingName();
        return new TestIdentifier(uniqueId, displayName, source, tags, type, parentId, legacyReportingName);
    }

    private TestIdentifier(UniqueId uniqueId, String displayName, @Nullable TestSource source, Set<TestTag> tags, TestDescriptor.Type type, @Nullable UniqueId parentId, String legacyReportingName) {
        Preconditions.notNull(type, "TestDescriptor.Type must not be null");
        this.uniqueId = uniqueId;
        this.parentId = parentId;
        this.displayName = displayName;
        this.source = source;
        this.tags = this.copyOf(tags);
        this.type = type;
        this.legacyReportingName = legacyReportingName;
    }

    private Set<TestTag> copyOf(Set<TestTag> tags) {
        return switch (tags.size()) {
            case 0 -> Collections.emptySet();
            case 1 -> Set.of(CollectionUtils.getOnlyElement(tags));
            default -> new LinkedHashSet<TestTag>(tags);
        };
    }

    public String getUniqueId() {
        return this.uniqueId.toString();
    }

    @API(status=API.Status.STABLE, since="1.8")
    public UniqueId getUniqueIdObject() {
        return this.uniqueId;
    }

    public Optional<String> getParentId() {
        return this.getParentIdObject().map(UniqueId::toString);
    }

    @API(status=API.Status.STABLE, since="1.8")
    public Optional<UniqueId> getParentIdObject() {
        return Optional.ofNullable(this.parentId);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getLegacyReportingName() {
        return this.legacyReportingName;
    }

    public TestDescriptor.Type getType() {
        return this.type;
    }

    public boolean isTest() {
        return this.getType().isTest();
    }

    public boolean isContainer() {
        return this.getType().isContainer();
    }

    public Optional<TestSource> getSource() {
        return Optional.ofNullable(this.source);
    }

    public Set<TestTag> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof TestIdentifier)) return false;
        TestIdentifier that = (TestIdentifier)obj;
        if (!Objects.equals(this.uniqueId, that.uniqueId)) return false;
        return true;
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("uniqueId", this.uniqueId).append("parentId", this.parentId).append("displayName", this.displayName).append("legacyReportingName", this.legacyReportingName).append("source", this.source).append("tags", this.tags).append("type", (Object)this.type).toString();
    }
}

