/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.CancellationToken;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.OutputDirectoryCreator;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.reporting.OutputDirectoryProvider;
import org.junit.platform.engine.support.store.Namespace;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;

@API(status=API.Status.STABLE, since="1.0")
public class ExecutionRequest {
    private final TestDescriptor rootTestDescriptor;
    private final EngineExecutionListener engineExecutionListener;
    private final ConfigurationParameters configurationParameters;
    private final @Nullable OutputDirectoryCreator outputDirectoryCreator;
    private final @Nullable NamespacedHierarchicalStore<Namespace> requestLevelStore;
    private final CancellationToken cancellationToken;

    @Deprecated(since="1.11")
    @API(status=API.Status.DEPRECATED, since="1.11")
    public ExecutionRequest(TestDescriptor rootTestDescriptor, EngineExecutionListener engineExecutionListener, ConfigurationParameters configurationParameters) {
        this(rootTestDescriptor, engineExecutionListener, configurationParameters, null, null, CancellationToken.disabled());
    }

    private ExecutionRequest(TestDescriptor rootTestDescriptor, EngineExecutionListener engineExecutionListener, ConfigurationParameters configurationParameters, @Nullable OutputDirectoryCreator outputDirectoryCreator, @Nullable NamespacedHierarchicalStore<Namespace> requestLevelStore, CancellationToken cancellationToken) {
        this.rootTestDescriptor = Preconditions.notNull(rootTestDescriptor, "rootTestDescriptor must not be null");
        this.engineExecutionListener = Preconditions.notNull(engineExecutionListener, "engineExecutionListener must not be null");
        this.configurationParameters = Preconditions.notNull(configurationParameters, "configurationParameters must not be null");
        this.outputDirectoryCreator = outputDirectoryCreator;
        this.requestLevelStore = requestLevelStore;
        this.cancellationToken = Preconditions.notNull(cancellationToken, "cancellationToken must not be null");
    }

    @Deprecated(since="1.11")
    @API(status=API.Status.DEPRECATED, since="1.11")
    public static ExecutionRequest create(TestDescriptor rootTestDescriptor, EngineExecutionListener engineExecutionListener, ConfigurationParameters configurationParameters) {
        return new ExecutionRequest(rootTestDescriptor, engineExecutionListener, configurationParameters);
    }

    @API(status=API.Status.INTERNAL, since="6.0")
    public static ExecutionRequest create(TestDescriptor rootTestDescriptor, EngineExecutionListener engineExecutionListener, ConfigurationParameters configurationParameters, OutputDirectoryCreator outputDirectoryCreator, NamespacedHierarchicalStore<Namespace> requestLevelStore, CancellationToken cancellationToken) {
        return new ExecutionRequest(rootTestDescriptor, engineExecutionListener, configurationParameters, Preconditions.notNull(outputDirectoryCreator, "outputDirectoryCreator must not be null"), Preconditions.notNull(requestLevelStore, "requestLevelStore must not be null"), Preconditions.notNull(cancellationToken, "cancellationToken must not be null"));
    }

    public TestDescriptor getRootTestDescriptor() {
        return this.rootTestDescriptor;
    }

    public EngineExecutionListener getEngineExecutionListener() {
        return this.engineExecutionListener;
    }

    public ConfigurationParameters getConfigurationParameters() {
        return this.configurationParameters;
    }

    @Deprecated(since="6.0", forRemoval=true)
    @API(status=API.Status.DEPRECATED, since="6.0")
    public OutputDirectoryProvider getOutputDirectoryProvider() {
        return OutputDirectoryProvider.castOrAdapt(this.getOutputDirectoryCreator());
    }

    @API(status=API.Status.MAINTAINED, since="6.0")
    public OutputDirectoryCreator getOutputDirectoryCreator() {
        return Preconditions.notNull(this.outputDirectoryCreator, "No OutputDirectoryCreator was configured for this request");
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.0")
    public NamespacedHierarchicalStore<Namespace> getStore() {
        return Preconditions.notNull(this.requestLevelStore, "No NamespacedHierarchicalStore was configured for this request");
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.0")
    public CancellationToken getCancellationToken() {
        return this.cancellationToken;
    }
}

