/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.output;

import java.io.PrintWriter;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.console.output.ColorPalette;
import org.junit.platform.console.output.DetailsPrintingListener;
import org.junit.platform.console.output.Style;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.FileEntry;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

@API(status=API.Status.INTERNAL, since="6.0")
public class FlatPrintingListener
implements DetailsPrintingListener {
    static final String INDENTATION = "             ";
    private final PrintWriter out;
    private final ColorPalette colorPalette;

    public FlatPrintingListener(PrintWriter out, ColorPalette colorPalette) {
        this.out = out;
        this.colorPalette = colorPalette;
    }

    @Override
    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.out.printf("Test execution started. Number of static tests: %d%n", testPlan.countTestIdentifiers(TestIdentifier::isTest));
    }

    @Override
    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.out.println("Test execution finished.");
    }

    @Override
    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        this.printlnTestDescriptor(Style.DYNAMIC, "Registered:", testIdentifier);
    }

    @Override
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.printlnTestDescriptor(Style.SKIPPED, "Skipped:", testIdentifier);
        this.printlnMessage(Style.SKIPPED, "Reason", reason);
    }

    @Override
    public void executionStarted(TestIdentifier testIdentifier) {
        this.printlnTestDescriptor(Style.valueOf(testIdentifier), "Started:", testIdentifier);
    }

    @Override
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        Style style = Style.valueOf(testExecutionResult);
        this.printlnTestDescriptor(style, "Finished:", testIdentifier);
        testExecutionResult.getThrowable().ifPresent(t -> this.printlnException(style, (Throwable)t));
    }

    @Override
    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        this.printlnTestDescriptor(Style.REPORTED, "Reported:", testIdentifier);
        this.printlnMessage(Style.REPORTED, "Reported values", entry.toString());
    }

    @Override
    public void fileEntryPublished(TestIdentifier testIdentifier, FileEntry file) {
        this.printlnTestDescriptor(Style.REPORTED, "Reported:", testIdentifier);
        this.printlnMessage(Style.REPORTED, "Reported file", file.toString());
    }

    private void printlnTestDescriptor(Style style, String message, TestIdentifier testIdentifier) {
        this.println(style, "%-10s   %s (%s)", message, testIdentifier.getDisplayName(), testIdentifier.getUniqueId());
    }

    private void printlnException(Style style, Throwable throwable) {
        this.printlnMessage(style, "Exception", ExceptionUtils.readStackTrace(throwable));
    }

    private void printlnMessage(Style style, String message, String detail) {
        this.println(style, "             => " + message + ": %s", FlatPrintingListener.indented(detail));
    }

    private void println(Style style, String format, Object ... args) {
        this.out.println(this.colorPalette.paint(style, format.formatted(args)));
    }

    private static String indented(String message) {
        return DetailsPrintingListener.indented(message, INDENTATION);
    }

    @Override
    public void listTests(TestPlan testPlan) {
        testPlan.accept(new TestPlan.Visitor(){

            @Override
            public void visit(TestIdentifier testIdentifier) {
                FlatPrintingListener.this.println(Style.valueOf(testIdentifier), "%s (%s)", testIdentifier.getDisplayName(), testIdentifier.getUniqueId());
            }
        });
    }
}

