/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.nio.file.Path;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.console.options.Details;
import org.junit.platform.console.options.TestConsoleOutputOptions;
import org.junit.platform.console.output.Theme;
import org.junit.platform.console.shadow.picocli.CommandLine;

@API(status=API.Status.INTERNAL, since="6.0")
public class TestConsoleOutputOptionsMixin {
    @CommandLine.ArgGroup(validate=false, order=5, heading="%n@|bold CONSOLE OUTPUT|@%n%n")
    ConsoleOutputOptions consoleOutputOptions = new ConsoleOutputOptions();

    public TestConsoleOutputOptions toTestConsoleOutputOptions() {
        TestConsoleOutputOptions result = new TestConsoleOutputOptions();
        if (this.consoleOutputOptions != null) {
            this.consoleOutputOptions.applyTo(result);
        }
        return result;
    }

    public static class ConsoleOutputOptions {
        @CommandLine.Option(names={"--color-palette"}, paramLabel="FILE", description={"Specify a path to a properties file to customize ANSI style of output (not supported by all terminals)."})
        private @Nullable Path colorPalette;
        @CommandLine.Option(names={"--single-color"}, description={"Style test output using only text attributes, no color (not supported by all terminals)."})
        private boolean singleColorPalette;
        @CommandLine.Option(names={"--details"}, paramLabel="MODE", defaultValue="tree", description={"Select an output details mode for when tests are executed. Use one of: ${COMPLETION-CANDIDATES}. If 'none' is selected, then only the summary and test failures are shown. Default: ${DEFAULT-VALUE}."})
        private final Details details = TestConsoleOutputOptions.DEFAULT_DETAILS;
        @CommandLine.Option(names={"--details-theme"}, paramLabel="THEME", description={"Select an output details tree theme for when tests are executed. Use one of: ${COMPLETION-CANDIDATES}. Default is detected based on default character encoding."})
        private final Theme theme = TestConsoleOutputOptions.DEFAULT_THEME;
        @CommandLine.Option(names={"--redirect-stdout"}, paramLabel="FILE", description={"Redirect test output to stdout to a file."})
        private @Nullable Path stdout;
        @CommandLine.Option(names={"--redirect-stderr"}, paramLabel="FILE", description={"Redirect test output to stderr to a file."})
        private @Nullable Path stderr;

        private void applyTo(TestConsoleOutputOptions result) {
            result.setColorPalettePath(this.colorPalette);
            result.setSingleColorPalette(this.singleColorPalette);
            result.setDetails(this.details);
            result.setTheme(this.theme);
            result.setStdoutPath(this.stdout);
            result.setStderrPath(this.stderr);
        }
    }
}

