/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.execution.NamespaceAwareStore;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.support.store.Namespace;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;

@API(status=API.Status.INTERNAL, since="6.0")
public class LauncherStoreFacade {
    private final NamespacedHierarchicalStore<Namespace> requestLevelStore;
    private final NamespacedHierarchicalStore<Namespace> sessionLevelStore;

    public LauncherStoreFacade(NamespacedHierarchicalStore<Namespace> requestLevelStore) {
        this.requestLevelStore = requestLevelStore;
        this.sessionLevelStore = requestLevelStore.getParent().orElseThrow(() -> new JUnitException("Request-level store must have a parent"));
    }

    public NamespacedHierarchicalStore<Namespace> getRequestLevelStore() {
        return this.requestLevelStore;
    }

    public ExtensionContext.Store getRequestLevelStore(ExtensionContext.Namespace namespace) {
        return this.getStoreAdapter(this.requestLevelStore, namespace);
    }

    public ExtensionContext.Store getSessionLevelStore(ExtensionContext.Namespace namespace) {
        return this.getStoreAdapter(this.sessionLevelStore, namespace);
    }

    public NamespaceAwareStore getStoreAdapter(NamespacedHierarchicalStore<Namespace> valuesStore, ExtensionContext.Namespace namespace) {
        Preconditions.notNull(namespace, "Namespace must not be null");
        return new NamespaceAwareStore(valuesStore, this.convert(namespace));
    }

    private Namespace convert(ExtensionContext.Namespace namespace) {
        return namespace.equals(ExtensionContext.Namespace.GLOBAL) ? Namespace.GLOBAL : Namespace.create(namespace.getParts());
    }
}

