/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.support.DefaultResource;
import org.junit.platform.commons.support.Resource;
import org.junit.platform.commons.support.scanning.ClassFilter;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="1.1")
public class ModuleUtils {
    private static final Logger logger = LoggerFactory.getLogger(ModuleUtils.class);

    public static Set<String> findAllNonSystemBootModuleNames() {
        Set systemModules = ModuleFinder.ofSystem().findAll().stream().map(reference -> reference.descriptor().name()).collect(Collectors.toSet());
        return ModuleUtils.streamResolvedModules(name -> !systemModules.contains(name)).map(ResolvedModule::name).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Optional<String> getModuleName(Class<?> type) {
        Preconditions.notNull(type, "Class type must not be null");
        return Optional.ofNullable(type.getModule().getName());
    }

    public static Optional<String> getModuleVersion(Class<?> type) {
        Preconditions.notNull(type, "Class type must not be null");
        Module module = type.getModule();
        return module.isNamed() ? module.getDescriptor().rawVersion() : Optional.empty();
    }

    public static List<Class<?>> findAllClassesInModule(String moduleName, ClassFilter filter) {
        Preconditions.notBlank(moduleName, "Module name must not be null or empty");
        Preconditions.notNull(filter, "Class filter must not be null");
        logger.debug(() -> "Looking for classes in module: " + moduleName);
        Set<ModuleReference> moduleReferences = ModuleUtils.streamResolvedModules(Predicate.isEqual(moduleName)).map(ResolvedModule::reference).collect(Collectors.toSet());
        return ModuleUtils.scan(moduleReferences, filter, ModuleUtils.class.getClassLoader());
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static List<Resource> findAllResourcesInModule(String moduleName, Predicate<Resource> filter) {
        Preconditions.notBlank(moduleName, "Module name must not be null or empty");
        Preconditions.notNull(filter, "Resource filter must not be null");
        logger.debug(() -> "Looking for classes in module: " + moduleName);
        Set<ModuleReference> moduleReferences = ModuleUtils.streamResolvedModules(Predicate.isEqual(moduleName)).map(ResolvedModule::reference).collect(Collectors.toSet());
        return ModuleUtils.scan(moduleReferences, filter, ModuleUtils.class.getClassLoader());
    }

    private static Stream<ResolvedModule> streamResolvedModules(Predicate<String> moduleNamePredicate) {
        Module module = ModuleUtils.class.getModule();
        ModuleLayer layer = module.getLayer();
        if (layer == null) {
            logger.config(() -> String.valueOf(ModuleUtils.class) + " is a member of " + String.valueOf(module) + " - using boot layer returned by ModuleLayer.boot() as fall-back.");
            layer = ModuleLayer.boot();
        }
        return ModuleUtils.streamResolvedModules(moduleNamePredicate, layer);
    }

    private static Stream<ResolvedModule> streamResolvedModules(Predicate<String> moduleNamePredicate, ModuleLayer layer) {
        logger.debug(() -> "Streaming modules for layer @" + System.identityHashCode(layer) + ": " + String.valueOf(layer));
        Configuration configuration = layer.configuration();
        logger.debug(() -> "Module layer configuration: " + String.valueOf(configuration));
        Stream stream = configuration.modules().stream();
        return stream.filter(module -> moduleNamePredicate.test(module.name()));
    }

    private static List<Class<?>> scan(Set<ModuleReference> references, ClassFilter filter, ClassLoader loader) {
        logger.debug(() -> "Scanning " + references.size() + " module references: " + String.valueOf(references));
        ModuleReferenceClassScanner scanner = new ModuleReferenceClassScanner(filter, loader);
        ArrayList classes = new ArrayList();
        for (ModuleReference reference : references) {
            classes.addAll(scanner.scan(reference));
        }
        logger.debug(() -> "Found " + classes.size() + " classes: " + String.valueOf(classes));
        return List.copyOf(classes);
    }

    private static List<Resource> scan(Set<ModuleReference> references, Predicate<Resource> filter, ClassLoader loader) {
        logger.debug(() -> "Scanning " + references.size() + " module references: " + String.valueOf(references));
        ModuleReferenceResourceScanner scanner = new ModuleReferenceResourceScanner(filter, loader);
        ArrayList<Resource> classes = new ArrayList<Resource>();
        for (ModuleReference reference : references) {
            classes.addAll(scanner.scan(reference));
        }
        logger.debug(() -> "Found " + classes.size() + " classes: " + String.valueOf(classes));
        return List.copyOf(classes);
    }

    private ModuleUtils() {
    }

    static class ModuleReferenceClassScanner {
        private final ClassFilter classFilter;
        private final ClassLoader classLoader;

        ModuleReferenceClassScanner(ClassFilter classFilter, ClassLoader classLoader) {
            this.classFilter = classFilter;
            this.classLoader = classLoader;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        List<Class<?>> scan(ModuleReference reference) {
            try (ModuleReader reader = reference.open();){
                List<Class<?>> list;
                block14: {
                    Stream<String> names = reader.list();
                    try {
                        list = names.filter(name -> name.endsWith(".class")).map(this::className).filter(name -> !"module-info".equals(name)).filter(this.classFilter::match).map(this::loadClassUnchecked).filter(this.classFilter::match).toList();
                        if (names == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (names != null) {
                            try {
                                names.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    names.close();
                }
                return list;
            }
            catch (IOException e) {
                throw new JUnitException("Failed to read contents of " + String.valueOf(reference) + ".", e);
            }
        }

        private String className(String resourceName) {
            resourceName = resourceName.substring(0, resourceName.length() - 6);
            resourceName = resourceName.replace('/', '.');
            return resourceName;
        }

        private Class<?> loadClassUnchecked(String binaryName) {
            try {
                return this.classLoader.loadClass(binaryName);
            }
            catch (ClassNotFoundException e) {
                throw new JUnitException("Failed to load class with name '" + binaryName + "'.", e);
            }
        }
    }

    static class ModuleReferenceResourceScanner {
        private final Predicate<Resource> resourceFilter;
        private final ClassLoader classLoader;

        ModuleReferenceResourceScanner(Predicate<Resource> resourceFilter, ClassLoader classLoader) {
            this.resourceFilter = resourceFilter;
            this.classLoader = classLoader;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        List<Resource> scan(ModuleReference reference) {
            try (ModuleReader reader = reference.open();){
                List<Resource> list;
                block14: {
                    Stream<String> names = reader.list();
                    try {
                        list = names.filter(name -> !name.endsWith(".class")).map(this::loadResourceUnchecked).filter(this.resourceFilter).toList();
                        if (names == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (names != null) {
                            try {
                                names.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    names.close();
                }
                return list;
            }
            catch (IOException e) {
                throw new JUnitException("Failed to read contents of " + String.valueOf(reference) + ".", e);
            }
        }

        private Resource loadResourceUnchecked(String binaryName) {
            try {
                URI uri = Objects.requireNonNull(this.classLoader.getResource(binaryName)).toURI();
                return new DefaultResource(binaryName, uri);
            }
            catch (NullPointerException | URISyntaxException e) {
                throw new JUnitException("Failed to load resource with name '" + binaryName + "'.", e);
            }
        }
    }
}

