/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.AbstractExtensionContext;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.LauncherStoreFacade;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

final class ClassExtensionContext
extends AbstractExtensionContext<ClassBasedTestDescriptor> {
    private final TestInstance.Lifecycle lifecycle;
    private final ThrowableCollector throwableCollector;
    private @Nullable TestInstances testInstances;

    ClassExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, ClassBasedTestDescriptor testDescriptor, TestInstance.Lifecycle lifecycle, JupiterConfiguration configuration, ExtensionRegistry extensionRegistry, LauncherStoreFacade launcherStoreFacade, ThrowableCollector throwableCollector) {
        super(parent, engineExecutionListener, testDescriptor, configuration, extensionRegistry, launcherStoreFacade);
        this.lifecycle = lifecycle;
        this.throwableCollector = throwableCollector;
    }

    @Override
    public Optional<AnnotatedElement> getElement() {
        return Optional.of(((ClassBasedTestDescriptor)this.getTestDescriptor()).getTestClass());
    }

    @Override
    public Optional<Class<?>> getTestClass() {
        return Optional.of(((ClassBasedTestDescriptor)this.getTestDescriptor()).getTestClass());
    }

    @Override
    public List<Class<?>> getEnclosingTestClasses() {
        return ((ClassBasedTestDescriptor)this.getTestDescriptor()).getEnclosingTestClasses();
    }

    @Override
    public Optional<TestInstance.Lifecycle> getTestInstanceLifecycle() {
        return Optional.of(this.lifecycle);
    }

    @Override
    public Optional<Object> getTestInstance() {
        return this.getTestInstances().map(TestInstances::getInnermostInstance);
    }

    @Override
    public Optional<TestInstances> getTestInstances() {
        return Optional.ofNullable(this.testInstances);
    }

    void setTestInstances(TestInstances testInstances) {
        this.testInstances = testInstances;
    }

    @Override
    public Optional<Method> getTestMethod() {
        return Optional.empty();
    }

    @Override
    public Optional<Throwable> getExecutionException() {
        return Optional.ofNullable(this.throwableCollector.getThrowable());
    }

    @Override
    protected Node.ExecutionMode getPlatformExecutionMode() {
        return ((ClassBasedTestDescriptor)this.getTestDescriptor()).getExecutionMode();
    }
}

