/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.execution;

import org.apiguardian.api.API;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.CancellationToken;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.descriptor.TestSourceProvider;
import org.junit.vintage.engine.execution.CancellationTokenAwareRunNotifier;
import org.junit.vintage.engine.execution.RunListenerAdapter;
import org.junit.vintage.engine.execution.TestRun;

@API(status=API.Status.INTERNAL, since="4.12")
public class RunnerExecutor {
    private final EngineExecutionListener engineExecutionListener;
    private final CancellationToken cancellationToken;
    private final TestSourceProvider testSourceProvider = new TestSourceProvider();

    public RunnerExecutor(EngineExecutionListener engineExecutionListener, CancellationToken cancellationToken) {
        this.engineExecutionListener = engineExecutionListener;
        this.cancellationToken = cancellationToken;
    }

    public void execute(RunnerTestDescriptor runnerTestDescriptor) {
        if (this.cancellationToken.isCancellationRequested()) {
            this.engineExecutionListener.executionSkipped(runnerTestDescriptor, "Execution cancelled");
            return;
        }
        CancellationTokenAwareRunNotifier notifier = new CancellationTokenAwareRunNotifier(this.cancellationToken);
        TestRun testRun = new TestRun(runnerTestDescriptor);
        RunListenerAdapter listener = new RunListenerAdapter(testRun, this.engineExecutionListener, this.testSourceProvider);
        notifier.addListener(listener);
        try {
            listener.testRunStarted(runnerTestDescriptor.getDescription());
            runnerTestDescriptor.getRunner().run(notifier);
            listener.testRunFinished();
        }
        catch (StoppedByUserException e) {
            this.reportEventsForCancellation(e, testRun);
        }
        catch (Throwable t) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(t);
            this.reportUnexpectedFailure(testRun, runnerTestDescriptor, TestExecutionResult.failed(t));
        }
    }

    private void reportEventsForCancellation(StoppedByUserException exception, TestRun testRun) {
        testRun.getInProgressTestDescriptors().forEach(startedDescriptor -> {
            startedDescriptor.getChildren().forEach(child -> {
                if (!testRun.isFinishedOrSkipped((TestDescriptor)child)) {
                    this.engineExecutionListener.executionSkipped((TestDescriptor)child, "Execution cancelled");
                    testRun.markSkipped((TestDescriptor)child);
                }
            });
            this.engineExecutionListener.executionFinished((TestDescriptor)startedDescriptor, TestExecutionResult.aborted(exception));
            testRun.markFinished((TestDescriptor)startedDescriptor);
        });
    }

    private void reportUnexpectedFailure(TestRun testRun, RunnerTestDescriptor runnerTestDescriptor, TestExecutionResult result) {
        if (testRun.isNotStarted(runnerTestDescriptor)) {
            this.engineExecutionListener.executionStarted(runnerTestDescriptor);
        }
        this.engineExecutionListener.executionFinished(runnerTestDescriptor, result);
    }
}

