/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.core.DelegatingEngineExecutionListener;

class StackTracePruningEngineExecutionListener
extends DelegatingEngineExecutionListener {
    StackTracePruningEngineExecutionListener(EngineExecutionListener delegate) {
        super(delegate);
    }

    @Override
    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
        List<String> testClassNames = StackTracePruningEngineExecutionListener.getTestClassNames(testDescriptor);
        if (testExecutionResult.getThrowable().isPresent()) {
            Throwable throwable = testExecutionResult.getThrowable().get();
            ExceptionUtils.findNestedThrowables(throwable).forEach(t -> ExceptionUtils.pruneStackTrace(t, testClassNames));
        }
        super.executionFinished(testDescriptor, testExecutionResult);
    }

    private static List<String> getTestClassNames(TestDescriptor testDescriptor) {
        Stream<TestDescriptor> self = Stream.of(testDescriptor);
        Stream ancestors = testDescriptor.getAncestors().stream();
        return Stream.concat(self, ancestors).map(TestDescriptor::getSource).flatMap(Optional::stream).map(source -> {
            if (source instanceof ClassSource) {
                ClassSource classSource = (ClassSource)source;
                return classSource.getClassName();
            }
            if (source instanceof MethodSource) {
                MethodSource methodSource = (MethodSource)source;
                return methodSource.getClassName();
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }
}

