/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.DiscoveryFilter;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.reporting.OutputDirectoryProvider;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.core.DefaultDiscoveryRequest;
import org.junit.platform.launcher.core.HierarchicalOutputDirectoryProvider;
import org.junit.platform.launcher.core.LauncherConfigurationParameters;
import org.junit.platform.launcher.core.LauncherExecutionRequestBuilder;
import org.junit.platform.launcher.listeners.OutputDir;
import org.junit.platform.launcher.listeners.discovery.LauncherDiscoveryListeners;

@API(status=API.Status.STABLE, since="1.0")
public final class LauncherDiscoveryRequestBuilder {
    public static final String DEFAULT_DISCOVERY_LISTENER_CONFIGURATION_PROPERTY_NAME = "junit.platform.discovery.listener.default";
    private static final String DEFAULT_DISCOVERY_LISTENER_CONFIGURATION_PROPERTY_VALUE = "abortOnFailure";
    private final List<DiscoverySelector> selectors = new ArrayList<DiscoverySelector>();
    private final List<EngineFilter> engineFilters = new ArrayList<EngineFilter>();
    private final List<DiscoveryFilter<?>> discoveryFilters = new ArrayList();
    private final List<PostDiscoveryFilter> postDiscoveryFilters = new ArrayList<PostDiscoveryFilter>();
    private final Map<String, String> configurationParameters = new HashMap<String, String>();
    private final List<String> configurationParametersResources = new ArrayList<String>();
    private final List<LauncherDiscoveryListener> discoveryListeners = new ArrayList<LauncherDiscoveryListener>();
    private boolean implicitConfigurationParametersEnabled = true;
    private @Nullable ConfigurationParameters parentConfigurationParameters;
    private @Nullable OutputDirectoryProvider outputDirectoryProvider;

    public static LauncherDiscoveryRequestBuilder request() {
        return new LauncherDiscoveryRequestBuilder();
    }

    private LauncherDiscoveryRequestBuilder() {
    }

    public LauncherDiscoveryRequestBuilder selectors(DiscoverySelector ... selectors) {
        Preconditions.notNull(selectors, "selectors array must not be null");
        this.selectors(Arrays.asList(selectors));
        return this;
    }

    public LauncherDiscoveryRequestBuilder selectors(List<? extends DiscoverySelector> selectors) {
        Preconditions.notNull(selectors, "selectors list must not be null");
        Preconditions.containsNoNullElements(selectors, "individual selectors must not be null");
        this.selectors.addAll(selectors);
        return this;
    }

    public LauncherDiscoveryRequestBuilder filters(Filter<?> ... filters) {
        Preconditions.notNull(filters, "filters array must not be null");
        Preconditions.containsNoNullElements(filters, "individual filters must not be null");
        Arrays.stream(filters).forEach(this::storeFilter);
        return this;
    }

    public LauncherDiscoveryRequestBuilder configurationParameter(String key, String value) {
        Preconditions.notBlank(key, "configuration parameter key must not be null or blank");
        this.configurationParameters.put(key, value);
        return this;
    }

    public LauncherDiscoveryRequestBuilder configurationParameters(Map<String, String> configurationParameters) {
        Preconditions.notNull(configurationParameters, "configuration parameters map must not be null");
        configurationParameters.forEach(this::configurationParameter);
        return this;
    }

    public LauncherDiscoveryRequestBuilder configurationParametersResources(String ... paths) {
        Preconditions.notNull(paths, "property file paths must not be null");
        Collections.addAll(this.configurationParametersResources, paths);
        return this;
    }

    @API(status=API.Status.STABLE, since="1.10")
    public LauncherDiscoveryRequestBuilder parentConfigurationParameters(ConfigurationParameters parentConfigurationParameters) {
        Preconditions.notNull(parentConfigurationParameters, "parent configuration parameters must not be null");
        this.parentConfigurationParameters = parentConfigurationParameters;
        return this;
    }

    @API(status=API.Status.STABLE, since="1.10")
    public LauncherDiscoveryRequestBuilder enableImplicitConfigurationParameters(boolean enabled) {
        this.implicitConfigurationParametersEnabled = enabled;
        return this;
    }

    @API(status=API.Status.STABLE, since="1.10")
    public LauncherDiscoveryRequestBuilder listeners(LauncherDiscoveryListener ... listeners) {
        Preconditions.notNull(listeners, "discovery listener array must not be null");
        Preconditions.containsNoNullElements(listeners, "individual discovery listeners must not be null");
        this.discoveryListeners.addAll(Arrays.asList(listeners));
        return this;
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public LauncherDiscoveryRequestBuilder outputDirectoryProvider(OutputDirectoryProvider outputDirectoryProvider) {
        this.outputDirectoryProvider = Preconditions.notNull(outputDirectoryProvider, "outputDirectoryProvider must not be null");
        return this;
    }

    private void storeFilter(Filter<?> filter) {
        if (filter instanceof EngineFilter) {
            EngineFilter engineFilter = (EngineFilter)filter;
            this.engineFilters.add(engineFilter);
        } else if (filter instanceof PostDiscoveryFilter) {
            PostDiscoveryFilter postDiscoveryFilter = (PostDiscoveryFilter)filter;
            this.postDiscoveryFilters.add(postDiscoveryFilter);
        } else if (filter instanceof DiscoveryFilter) {
            DiscoveryFilter discoveryFilter = (DiscoveryFilter)filter;
            this.discoveryFilters.add(discoveryFilter);
        } else {
            throw new PreconditionViolationException("Filter [%s] must implement %s, %s, or %s.".formatted(filter, EngineFilter.class.getSimpleName(), PostDiscoveryFilter.class.getSimpleName(), DiscoveryFilter.class.getSimpleName()));
        }
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.0")
    public LauncherExecutionRequestBuilder forExecution() {
        return LauncherExecutionRequestBuilder.request(this.build());
    }

    public LauncherDiscoveryRequest build() {
        LauncherConfigurationParameters launcherConfigurationParameters = this.buildLauncherConfigurationParameters();
        LauncherDiscoveryListener discoveryListener = this.getLauncherDiscoveryListener(launcherConfigurationParameters);
        OutputDirectoryProvider outputDirectoryProvider = this.getOutputDirectoryProvider(launcherConfigurationParameters);
        return new DefaultDiscoveryRequest(this.selectors, this.engineFilters, this.discoveryFilters, this.postDiscoveryFilters, launcherConfigurationParameters, discoveryListener, outputDirectoryProvider);
    }

    private OutputDirectoryProvider getOutputDirectoryProvider(LauncherConfigurationParameters configurationParameters) {
        if (this.outputDirectoryProvider != null) {
            return this.outputDirectoryProvider;
        }
        return new HierarchicalOutputDirectoryProvider(() -> OutputDir.create(configurationParameters.get("junit.platform.reporting.output.dir")).toPath());
    }

    private LauncherConfigurationParameters buildLauncherConfigurationParameters() {
        LauncherConfigurationParameters.Builder builder = LauncherConfigurationParameters.builder().explicitParameters(this.configurationParameters).configurationResources(this.configurationParametersResources).enableImplicitProviders(this.implicitConfigurationParametersEnabled);
        if (this.parentConfigurationParameters != null) {
            builder.parentConfigurationParameters(this.parentConfigurationParameters);
        }
        return builder.build();
    }

    private LauncherDiscoveryListener getLauncherDiscoveryListener(ConfigurationParameters configurationParameters) {
        LauncherDiscoveryListener defaultDiscoveryListener = this.getDefaultLauncherDiscoveryListener(configurationParameters);
        if (this.discoveryListeners.isEmpty()) {
            return defaultDiscoveryListener;
        }
        if (this.discoveryListeners.contains(defaultDiscoveryListener)) {
            return LauncherDiscoveryListeners.composite(this.discoveryListeners);
        }
        ArrayList<LauncherDiscoveryListener> allDiscoveryListeners = new ArrayList<LauncherDiscoveryListener>(this.discoveryListeners.size() + 1);
        allDiscoveryListeners.addAll(this.discoveryListeners);
        allDiscoveryListeners.add(defaultDiscoveryListener);
        return LauncherDiscoveryListeners.composite(allDiscoveryListeners);
    }

    private LauncherDiscoveryListener getDefaultLauncherDiscoveryListener(ConfigurationParameters configurationParameters) {
        String value = configurationParameters.get(DEFAULT_DISCOVERY_LISTENER_CONFIGURATION_PROPERTY_NAME).orElse(DEFAULT_DISCOVERY_LISTENER_CONFIGURATION_PROPERTY_VALUE);
        return LauncherDiscoveryListeners.fromConfigurationParameter(DEFAULT_DISCOVERY_LISTENER_CONFIGURATION_PROPERTY_NAME, value);
    }
}

