/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.util.Objects;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.TestSource;

@API(status=API.Status.STABLE, since="1.0")
public final class PackageSource
implements TestSource {
    private static final long serialVersionUID = 1L;
    private final String packageName;

    public static PackageSource from(Package javaPackage) {
        return new PackageSource(javaPackage);
    }

    public static PackageSource from(String packageName) {
        return new PackageSource(packageName);
    }

    private PackageSource(Package javaPackage) {
        this(Preconditions.notNull(javaPackage, "package must not be null").getName());
    }

    private PackageSource(String packageName) {
        Preconditions.notNull(packageName, "package name must not be null");
        Preconditions.condition(packageName.isEmpty() || !packageName.isBlank(), "package name must not contain only whitespace");
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageSource that = (PackageSource)o;
        return Objects.equals(this.packageName, that.packageName);
    }

    public int hashCode() {
        return this.packageName.hashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("packageName", this.packageName).toString();
    }
}

