/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.junit.platform.console.options.AnsiColorOptionMixin;
import org.junit.platform.console.options.BaseCommand;
import org.junit.platform.console.options.CommandResult;
import org.junit.platform.console.options.DiscoverTestsCommand;
import org.junit.platform.console.options.ExecuteTestsCommand;
import org.junit.platform.console.options.ListTestEnginesCommand;
import org.junit.platform.console.options.ManifestVersionProvider;
import org.junit.platform.console.options.OutputStreamConfig;
import org.junit.platform.console.shadow.picocli.CommandLine;
import org.junit.platform.console.tasks.ConsoleTestExecutor;

@CommandLine.Command(name="junit", abbreviateSynopsis=true, synopsisSubcommandLabel="COMMAND", sortOptions=false, usageHelpWidth=95, showAtFileInUsageHelp=true, usageHelpAutoWidth=true, description={"Launches the JUnit Platform for test discovery and execution."}, footerHeading="%n", footer={"For more information, please refer to the JUnit User Guide at%n@|underline https://docs.junit.org/${junit.docs.version}/user-guide/|@"}, scope=CommandLine.ScopeType.INHERIT, exitCodeOnInvalidInput=-1, exitCodeOnExecutionException=-1, versionProvider=ManifestVersionProvider.class)
class MainCommand
implements Runnable,
CommandLine.IExitCodeGenerator {
    private final ConsoleTestExecutor.Factory consoleTestExecutorFactory;
    @CommandLine.Option(names={"-h", "--help"}, help=true, description={"Display help information."})
    private boolean helpRequested;
    @CommandLine.Option(names={"--version"}, versionHelp=true, description={"Display version information."})
    private boolean versionRequested;
    @CommandLine.Mixin
    AnsiColorOptionMixin ansiColorOption;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec commandSpec;
    @Nullable CommandResult<?> commandResult;

    MainCommand(ConsoleTestExecutor.Factory consoleTestExecutorFactory) {
        this.consoleTestExecutorFactory = consoleTestExecutorFactory;
    }

    @Override
    public void run() {
        if (this.helpRequested) {
            this.commandSpec.commandLine().usage(this.commandSpec.commandLine().getOut());
            this.commandResult = CommandResult.success();
        } else if (this.versionRequested) {
            this.commandSpec.commandLine().printVersionHelp(this.commandSpec.commandLine().getOut());
            this.commandResult = CommandResult.success();
        } else {
            throw new CommandLine.ParameterException(this.commandSpec.commandLine(), "Missing required subcommand");
        }
    }

    @Override
    public int getExitCode() {
        return Objects.requireNonNull(this.commandResult).getExitCode();
    }

    CommandResult<?> run(String[] args, Optional<OutputStreamConfig> outputStreamConfig) {
        CommandLine commandLine = new CommandLine(this).addSubcommand(new DiscoverTestsCommand(this.consoleTestExecutorFactory)).addSubcommand(new ExecuteTestsCommand(this.consoleTestExecutorFactory)).addSubcommand(new ListTestEnginesCommand());
        return MainCommand.runCommand(commandLine, args, outputStreamConfig);
    }

    private static CommandResult<?> runCommand(CommandLine commandLine, String[] args, Optional<OutputStreamConfig> outputStreamConfig) {
        BaseCommand.initialize(commandLine);
        outputStreamConfig.ifPresent(it -> it.applyTo(commandLine));
        int exitCode = commandLine.execute(args);
        return CommandResult.create(exitCode, MainCommand.getLikelyExecutedCommand(commandLine).getExecutionResult());
    }

    private static CommandLine getLikelyExecutedCommand(CommandLine commandLine) {
        return Optional.ofNullable(commandLine.getParseResult().subcommand()).map(parseResult -> parseResult.commandSpec().commandLine()).orElse(commandLine);
    }
}

