/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="1.0")
public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> T getOnlyElement(Collection<T> collection) {
        Preconditions.notNull(collection, "collection must not be null");
        Preconditions.condition(collection.size() == 1, () -> "collection must contain exactly one element: " + String.valueOf(collection));
        return CollectionUtils.firstElement(collection);
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static <T> Optional<T> getFirstElement(Collection<T> collection) {
        Preconditions.notNull(collection, "collection must not be null");
        return collection.isEmpty() ? Optional.empty() : Optional.ofNullable(CollectionUtils.firstElement(collection));
    }

    private static <T> T firstElement(Collection<T> collection) {
        Object object;
        if (collection instanceof List) {
            List list = (List)collection;
            object = list.get(0);
        } else {
            object = collection.iterator().next();
        }
        return object;
    }

    @API(status=API.Status.INTERNAL, since="1.9.1")
    public static boolean isConvertibleToStream(@Nullable Class<?> type) {
        if (type == null || type == Void.TYPE) {
            return false;
        }
        return Stream.class.isAssignableFrom(type) || DoubleStream.class.isAssignableFrom(type) || IntStream.class.isAssignableFrom(type) || LongStream.class.isAssignableFrom(type) || Iterable.class.isAssignableFrom(type) || Iterator.class.isAssignableFrom(type) || Object[].class.isAssignableFrom(type) || type.isArray() && type.getComponentType().isPrimitive() || CollectionUtils.findIteratorMethod(type).isPresent();
    }

    public static Stream<?> toStream(Object object) {
        Preconditions.notNull(object, "Object must not be null");
        if (object instanceof Stream) {
            Stream stream = (Stream)object;
            return stream;
        }
        if (object instanceof DoubleStream) {
            DoubleStream stream = (DoubleStream)object;
            return stream.boxed();
        }
        if (object instanceof IntStream) {
            IntStream stream = (IntStream)object;
            return stream.boxed();
        }
        if (object instanceof LongStream) {
            LongStream stream = (LongStream)object;
            return stream.boxed();
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return collection.stream();
        }
        if (object instanceof Iterable) {
            Iterable iterable = (Iterable)object;
            return StreamSupport.stream(iterable.spliterator(), false);
        }
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
        }
        if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            return Arrays.stream(array);
        }
        if (object instanceof double[]) {
            double[] array = (double[])object;
            return DoubleStream.of(array).boxed();
        }
        if (object instanceof int[]) {
            int[] array = (int[])object;
            return IntStream.of(array).boxed();
        }
        if (object instanceof long[]) {
            long[] array = (long[])object;
            return LongStream.of(array).boxed();
        }
        if (object.getClass().isArray() && object.getClass().getComponentType().isPrimitive()) {
            return IntStream.range(0, Array.getLength(object)).mapToObj(i2 -> Array.get(object, i2));
        }
        return CollectionUtils.tryConvertToStreamByReflection(object);
    }

    private static Stream<?> tryConvertToStreamByReflection(Object object) {
        return CollectionUtils.findIteratorMethod(object.getClass()).map(method -> (Iterator)ReflectionSupport.invokeMethod(method, object, new Object[0])).map(iterator -> Spliterators.spliteratorUnknownSize(iterator, 16)).map(spliterator -> StreamSupport.stream(spliterator, false)).orElseThrow(() -> new PreconditionViolationException("Cannot convert instance of %s into a Stream: %s".formatted(object.getClass().getName(), object)));
    }

    private static Optional<Method> findIteratorMethod(Class<?> type) {
        return ReflectionSupport.findMethod(type, "iterator", new Class[0]).filter(method -> method.getReturnType() == Iterator.class);
    }

    @API(status=API.Status.INTERNAL, since="1.9.2")
    public static <T> void forEachInReverseOrder(List<T> list, Consumer<? super T> action) {
        if (list.isEmpty()) {
            return;
        }
        if (list.size() == 1) {
            action.accept(list.get(0));
            return;
        }
        ListIterator<T> iterator = list.listIterator(list.size());
        while (iterator.hasPrevious()) {
            action.accept(iterator.previous());
        }
    }
}

