/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.support;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.KotlinReflectionUtils;

@API(status=API.Status.INTERNAL, since="6.0")
public class MethodReflectionUtils {
    public static Class<?> getReturnType(Method method) {
        return KotlinReflectionUtils.isKotlinSuspendingFunction(method) ? KotlinReflectionUtils.getKotlinSuspendingFunctionReturnType(method) : method.getReturnType();
    }

    public static Type getGenericReturnType(Method method) {
        return KotlinReflectionUtils.isKotlinSuspendingFunction(method) ? KotlinReflectionUtils.getKotlinSuspendingFunctionGenericReturnType(method) : method.getGenericReturnType();
    }

    public static @Nullable Object invoke(Method method, @Nullable Object target, @Nullable Object[] arguments) {
        if (KotlinReflectionUtils.isKotlinSuspendingFunction(method)) {
            return KotlinReflectionUtils.invokeKotlinSuspendingFunction(method, target, arguments);
        }
        return ReflectionSupport.invokeMethod(method, target, arguments);
    }

    private MethodReflectionUtils() {
    }
}

