/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.descriptor.VintageTestDescriptor;

class UniqueIdFilter
extends Filter {
    private final RunnerTestDescriptor runnerTestDescriptor;
    private final UniqueId uniqueId;
    private Deque<Description> path;
    private Set<Description> descendants;

    UniqueIdFilter(RunnerTestDescriptor runnerTestDescriptor, UniqueId uniqueId) {
        this.runnerTestDescriptor = runnerTestDescriptor;
        this.uniqueId = uniqueId;
    }

    private void ensureInitialized() {
        if (this.descendants == null) {
            Optional<? extends TestDescriptor> identifiedTestDescriptor = this.runnerTestDescriptor.findByUniqueId(this.uniqueId);
            this.descendants = this.determineDescendants(identifiedTestDescriptor);
            this.path = this.determinePath(this.runnerTestDescriptor, identifiedTestDescriptor);
        }
    }

    private Deque<Description> determinePath(RunnerTestDescriptor runnerTestDescriptor, Optional<? extends TestDescriptor> identifiedTestDescriptor) {
        ArrayDeque<Description> path = new ArrayDeque<Description>();
        Optional<? extends TestDescriptor> current = identifiedTestDescriptor;
        while (current.isPresent() && !current.get().equals(runnerTestDescriptor)) {
            path.addFirst(((VintageTestDescriptor)current.get()).getDescription());
            current = current.get().getParent();
        }
        return path;
    }

    private Set<Description> determineDescendants(Optional<? extends TestDescriptor> identifiedTestDescriptor) {
        return identifiedTestDescriptor.map(testDescriptor -> testDescriptor.getDescendants().stream().map(VintageTestDescriptor.class::cast).map(VintageTestDescriptor::getDescription).collect(Collectors.toSet())).orElseGet(Collections::emptySet);
    }

    @Override
    public boolean shouldRun(Description description) {
        this.ensureInitialized();
        return this.path.contains(description) || this.descendants.contains(description);
    }

    @Override
    public String describe() {
        return "Unique ID " + String.valueOf(this.uniqueId);
    }
}

