/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.discovery;

import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.EngineDiscoveryListener;
import org.junit.platform.engine.UniqueId;

@API(status=API.Status.EXPERIMENTAL, since="6.0")
public interface DiscoveryIssueReporter {
    public static DiscoveryIssueReporter forwarding(EngineDiscoveryListener engineDiscoveryListener, UniqueId engineId) {
        Preconditions.notNull(engineDiscoveryListener, "engineDiscoveryListener must not be null");
        Preconditions.notNull(engineId, "engineId must not be null");
        return issue -> engineDiscoveryListener.issueEncountered(engineId, issue);
    }

    public static DiscoveryIssueReporter collecting(Collection<? super DiscoveryIssue> collection) {
        Preconditions.notNull(collection, "collection must not be null");
        return DiscoveryIssueReporter.consuming(collection::add);
    }

    public static DiscoveryIssueReporter consuming(Consumer<? super DiscoveryIssue> consumer) {
        Preconditions.notNull(consumer, "consumer must not be null");
        return consumer::accept;
    }

    public static DiscoveryIssueReporter deduplicating(DiscoveryIssueReporter delegate) {
        Preconditions.notNull(delegate, "delegate must not be null");
        HashSet seen = new HashSet();
        return issue -> {
            boolean notSeen = seen.add(issue);
            if (notSeen) {
                delegate.reportIssue(issue);
            }
        };
    }

    default public void reportIssue(DiscoveryIssue.Builder builder) {
        this.reportIssue(builder.build());
    }

    public void reportIssue(DiscoveryIssue var1);

    default public <T> Condition<T> createReportingCondition(Predicate<T> predicate, Function<T, DiscoveryIssue> issueCreator) {
        Preconditions.notNull(predicate, "predicate must not be null");
        Preconditions.notNull(issueCreator, "issueCreator must not be null");
        return value -> {
            if (predicate.test(value)) {
                return true;
            }
            this.reportIssue((DiscoveryIssue)issueCreator.apply(value));
            return false;
        };
    }

    public static interface Condition<T> {
        public static <T> Condition<T> alwaysSatisfied() {
            return __ -> true;
        }

        public boolean check(T var1);

        default public Condition<T> and(Condition<? super T> that) {
            Preconditions.notNull(that, "condition must not be null");
            return value -> this.check(value) & that.check(value);
        }

        default public Predicate<T> toPredicate() {
            return this::check;
        }

        default public Consumer<T> toConsumer() {
            return this::check;
        }
    }
}

