/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.reporting;

import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;

@API(status=API.Status.MAINTAINED, since="1.13.3")
public final class FileEntry {
    private final LocalDateTime timestamp = LocalDateTime.now(ZoneId.systemDefault());
    private final Path path;
    private final @Nullable String mediaType;

    public static FileEntry from(Path path, @Nullable String mediaType) {
        return new FileEntry(path, mediaType);
    }

    private FileEntry(Path path, @Nullable String mediaType) {
        this.path = Preconditions.notNull(path, "path must not be null");
        this.mediaType = mediaType;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public Path getPath() {
        return this.path;
    }

    public Optional<String> getMediaType() {
        return Optional.ofNullable(this.mediaType);
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        builder.append("timestamp", this.timestamp);
        builder.append("path", this.path);
        if (this.mediaType != null) {
            builder.append("mediaType", this.mediaType);
        }
        return builder.toString();
    }
}

