/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.DiscoverySelectorIdentifier;
import org.junit.platform.engine.discovery.DiscoverySelectorIdentifierParser;
import org.junit.platform.engine.discovery.DiscoverySelectors;

@API(status=API.Status.STABLE, since="1.0")
public final class ClasspathRootSelector
implements DiscoverySelector {
    private final URI classpathRoot;

    ClasspathRootSelector(URI classpathRoot) {
        this.classpathRoot = Preconditions.notNull(classpathRoot, "classpathRoot must not be null");
    }

    public URI getClasspathRoot() {
        return this.classpathRoot;
    }

    @API(status=API.Status.STABLE, since="1.3")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClasspathRootSelector that = (ClasspathRootSelector)o;
        return Objects.equals(this.classpathRoot, that.classpathRoot);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public int hashCode() {
        return this.classpathRoot.hashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("classpathRoot", this.classpathRoot).toString();
    }

    @Override
    public Optional<DiscoverySelectorIdentifier> toIdentifier() {
        return Optional.of(DiscoverySelectorIdentifier.create("classpath-root", this.classpathRoot.toString()));
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static class IdentifierParser
    implements DiscoverySelectorIdentifierParser {
        private static final String PREFIX = "classpath-root";

        @Override
        public String getPrefix() {
            return PREFIX;
        }

        public Optional<ClasspathRootSelector> parse(DiscoverySelectorIdentifier identifier, DiscoverySelectorIdentifierParser.Context context) {
            Path path = Path.of(URI.create(identifier.getValue()));
            return CollectionUtils.getFirstElement(DiscoverySelectors.selectClasspathRoots(Collections.singleton(path)));
        }
    }
}

