/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console;

import java.io.PrintWriter;
import org.apiguardian.api.API;
import org.junit.platform.console.options.CommandFacade;
import org.junit.platform.console.options.CommandResult;
import org.junit.platform.console.tasks.ConsoleTestExecutor;
import org.junit.platform.console.tasks.CustomClassLoaderCloseStrategy;

@API(status=API.Status.MAINTAINED, since="1.0")
public class ConsoleLauncher {
    public static void main(String ... args) {
        CommandFacade facade = ConsoleLauncher.newCommandFacade(CustomClassLoaderCloseStrategy.KEEP_OPEN);
        CommandResult<?> result = facade.run(args);
        System.exit(result.getExitCode());
    }

    @API(status=API.Status.INTERNAL, since="1.0")
    public static CommandResult<?> run(PrintWriter out, PrintWriter err, String ... args) {
        CommandFacade facade = ConsoleLauncher.newCommandFacade(CustomClassLoaderCloseStrategy.CLOSE_AFTER_CALLING_LAUNCHER);
        return facade.run(args, out, err);
    }

    private static CommandFacade newCommandFacade(CustomClassLoaderCloseStrategy classLoaderCleanupStrategy) {
        return new CommandFacade((discoveryOptions, outputOptions) -> new ConsoleTestExecutor(discoveryOptions, outputOptions, classLoaderCleanupStrategy));
    }

    private ConsoleLauncher() {
    }
}

