/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.EvaluatedArgumentSet;
import org.junit.jupiter.params.ParameterizedDeclarationContext;
import org.junit.jupiter.params.ResolverFacade;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;

class ParameterizedInvocationNameFormatter {
    static final String DEFAULT_DISPLAY_NAME = "{default_display_name}";
    static final String DEFAULT_DISPLAY_NAME_PATTERN = "[{index}] {argumentSetNameOrArgumentsWithNames}";
    static final String DISPLAY_NAME_PATTERN_KEY = "junit.jupiter.params.displayname.default";
    static final String ARGUMENT_MAX_LENGTH_KEY = "junit.jupiter.params.displayname.argument.maxlength";
    private final PartialFormatter[] partialFormatters;

    static ParameterizedInvocationNameFormatter create(ExtensionContext extensionContext, ParameterizedDeclarationContext<?> declarationContext) {
        String name = declarationContext.getDisplayNamePattern();
        String pattern = DEFAULT_DISPLAY_NAME.equals(name) ? extensionContext.getConfigurationParameter(DISPLAY_NAME_PATTERN_KEY).orElse(DEFAULT_DISPLAY_NAME_PATTERN) : name;
        pattern = Preconditions.notBlank(pattern.strip(), () -> "Configuration error: @%s on %s must be declared with a non-empty name.".formatted(declarationContext.getAnnotationName(), declarationContext.getResolverFacade().getIndexedParameterDeclarations().getSourceElementDescription()));
        int argumentMaxLength = extensionContext.getConfigurationParameter(ARGUMENT_MAX_LENGTH_KEY, Integer::parseInt).orElse(512);
        return new ParameterizedInvocationNameFormatter(pattern, extensionContext.getDisplayName(), declarationContext, argumentMaxLength);
    }

    ParameterizedInvocationNameFormatter(String pattern, String displayName, ParameterizedDeclarationContext<?> declarationContext, int argumentMaxLength) {
        try {
            this.partialFormatters = this.parse(pattern, displayName, declarationContext, argumentMaxLength);
        }
        catch (Exception ex) {
            String message = "The display name pattern defined for the parameterized test is invalid. See nested exception for further details.";
            throw new JUnitException(message, ex);
        }
    }

    String format(int invocationIndex, EvaluatedArgumentSet arguments) {
        try {
            return this.formatSafely(invocationIndex, arguments);
        }
        catch (Exception ex) {
            String message = "Failed to format display name for parameterized test. See nested exception for further details.";
            throw new JUnitException(message, ex);
        }
    }

    private String formatSafely(int invocationIndex, EvaluatedArgumentSet arguments) {
        ArgumentsContext context = new ArgumentsContext(invocationIndex, arguments.getConsumedNames(), arguments.getName());
        StringBuffer result = new StringBuffer();
        for (PartialFormatter partialFormatter : this.partialFormatters) {
            partialFormatter.append(context, result);
        }
        return result.toString();
    }

    private PartialFormatter[] parse(String pattern, String displayName, ParameterizedDeclarationContext<?> declarationContext, int argumentMaxLength) {
        ArrayList<PartialFormatter> result = new ArrayList<PartialFormatter>();
        PartialFormatters formatters = this.createPartialFormatters(displayName, declarationContext, argumentMaxLength);
        String unparsedSegment = pattern;
        while (StringUtils.isNotBlank(unparsedSegment)) {
            PlaceholderPosition position = ParameterizedInvocationNameFormatter.findFirstPlaceholder(formatters, unparsedSegment);
            if (position == null) {
                result.add(ParameterizedInvocationNameFormatter.determineNonPlaceholderFormatter(unparsedSegment, argumentMaxLength));
                break;
            }
            if (position.index > 0) {
                String before = unparsedSegment.substring(0, position.index);
                result.add(ParameterizedInvocationNameFormatter.determineNonPlaceholderFormatter(before, argumentMaxLength));
            }
            result.add(formatters.get(position.placeholder));
            unparsedSegment = unparsedSegment.substring(position.index + position.placeholder.length());
        }
        return result.toArray(new PartialFormatter[0]);
    }

    private static @Nullable PlaceholderPosition findFirstPlaceholder(PartialFormatters formatters, String segment) {
        if (segment.length() < formatters.minimumPlaceholderLength) {
            return null;
        }
        PlaceholderPosition minimum = null;
        for (String placeholder : formatters.placeholders()) {
            int index = segment.indexOf(placeholder);
            if (index < 0) continue;
            if (index < formatters.minimumPlaceholderLength) {
                return new PlaceholderPosition(index, placeholder);
            }
            if (minimum != null && index >= minimum.index) continue;
            minimum = new PlaceholderPosition(index, placeholder);
        }
        return minimum;
    }

    private static PartialFormatter determineNonPlaceholderFormatter(String segment, int argumentMaxLength) {
        return segment.contains("{") ? new MessageFormatPartialFormatter(segment, argumentMaxLength) : (context, result) -> result.append(segment);
    }

    private PartialFormatters createPartialFormatters(String displayName, ParameterizedDeclarationContext<?> declarationContext, int argumentMaxLength) {
        CachingByArgumentsLengthPartialFormatter argumentsWithNamesFormatter = new CachingByArgumentsLengthPartialFormatter(length -> new MessageFormatPartialFormatter(ParameterizedInvocationNameFormatter.argumentsWithNamesPattern(length, declarationContext), argumentMaxLength));
        ArgumentSetNameFormatter argumentSetNameFormatter = new ArgumentSetNameFormatter(declarationContext.getAnnotationName());
        PartialFormatters formatters = new PartialFormatters();
        formatters.put("{index}", PartialFormatter.INDEX);
        formatters.put("{displayName}", (context, result) -> result.append(displayName));
        formatters.put("{argumentSetName}", argumentSetNameFormatter);
        formatters.put("{argumentsWithNames}", argumentsWithNamesFormatter);
        formatters.put("{arguments}", new CachingByArgumentsLengthPartialFormatter(length -> new MessageFormatPartialFormatter(ParameterizedInvocationNameFormatter.argumentsPattern(length), argumentMaxLength)));
        formatters.put("{argumentSetNameOrArgumentsWithNames}", (context, result) -> {
            PartialFormatter formatterToUse = context.argumentSetName.isPresent() ? argumentSetNameFormatter : argumentsWithNamesFormatter;
            formatterToUse.append(context, result);
        });
        return formatters;
    }

    private static String argumentsWithNamesPattern(int length, ParameterizedDeclarationContext<?> declarationContext) {
        ResolverFacade resolverFacade = declarationContext.getResolverFacade();
        return IntStream.range(0, length).mapToObj(index -> resolverFacade.getParameterName(index).map(name -> name + " = ").orElse("") + "{" + index + "}").collect(Collectors.joining(", "));
    }

    private static String argumentsPattern(int length) {
        return IntStream.range(0, length).mapToObj(index -> "{" + index + "}").collect(Collectors.joining(", "));
    }

    @FunctionalInterface
    private static interface PartialFormatter {
        public static final PartialFormatter INDEX = (context, result) -> result.append(context.invocationIndex);

        public void append(ArgumentsContext var1, StringBuffer var2);
    }

    private record ArgumentsContext(int invocationIndex, @Nullable Object[] consumedArguments, Optional<String> argumentSetName) {
    }

    private static class PartialFormatters {
        private final Map<String, PartialFormatter> formattersByPlaceholder = new LinkedHashMap<String, PartialFormatter>();
        private int minimumPlaceholderLength = Integer.MAX_VALUE;

        private PartialFormatters() {
        }

        void put(String placeholder, PartialFormatter formatter) {
            this.formattersByPlaceholder.put(placeholder, formatter);
            int newPlaceholderLength = placeholder.length();
            if (newPlaceholderLength < this.minimumPlaceholderLength) {
                this.minimumPlaceholderLength = newPlaceholderLength;
            }
        }

        PartialFormatter get(String placeholder) {
            return Objects.requireNonNull(this.formattersByPlaceholder.get(placeholder));
        }

        Set<String> placeholders() {
            return this.formattersByPlaceholder.keySet();
        }
    }

    private record PlaceholderPosition(int index, String placeholder) {
    }

    private static class MessageFormatPartialFormatter
    implements PartialFormatter {
        private static final char ELLIPSIS = '\u2026';
        private final MessageFormat messageFormat;
        private final int argumentMaxLength;

        MessageFormatPartialFormatter(String pattern, int argumentMaxLength) {
            this.messageFormat = new MessageFormat(pattern);
            this.argumentMaxLength = argumentMaxLength;
        }

        @Override
        public synchronized void append(ArgumentsContext context, StringBuffer result) {
            this.messageFormat.format(this.makeReadable(context.consumedArguments), result, new FieldPosition(0));
        }

        private @Nullable Object[] makeReadable(@Nullable Object[] arguments) {
            @Nullable Format[] formats = this.messageFormat.getFormatsByArgumentIndex();
            @Nullable Object[] result = Arrays.copyOf(arguments, Math.min(arguments.length, formats.length), Object[].class);
            for (int i2 = 0; i2 < result.length; ++i2) {
                if (formats[i2] != null) continue;
                result[i2] = this.truncateIfExceedsMaxLength(StringUtils.nullSafeToString(arguments[i2]));
            }
            return result;
        }

        private @Nullable String truncateIfExceedsMaxLength(@Nullable String argument) {
            if (argument != null && argument.length() > this.argumentMaxLength) {
                return argument.substring(0, this.argumentMaxLength - 1) + "\u2026";
            }
            return argument;
        }
    }

    private static class CachingByArgumentsLengthPartialFormatter
    implements PartialFormatter {
        private final ConcurrentMap<Integer, PartialFormatter> cache = new ConcurrentHashMap<Integer, PartialFormatter>(1);
        private final Function<Integer, PartialFormatter> factory;

        CachingByArgumentsLengthPartialFormatter(Function<Integer, PartialFormatter> factory) {
            this.factory = factory;
        }

        @Override
        public void append(ArgumentsContext context, StringBuffer result) {
            this.cache.computeIfAbsent(context.consumedArguments.length, this.factory).append(context, result);
        }
    }

    private record ArgumentSetNameFormatter(String annotationName) implements PartialFormatter
    {
        @Override
        public void append(ArgumentsContext context, StringBuffer result) {
            if (context.argumentSetName.isPresent()) {
                result.append(context.argumentSetName.get());
                return;
            }
            throw new ExtensionConfigurationException("When the display name pattern for a @%s contains %s, the arguments must be supplied as an ArgumentSet.".formatted(this.annotationName, "{argumentSetName}"));
        }
    }
}

