/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.junit.jupiter.api.MethodDescriptor;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.jupiter.engine.discovery.AbstractOrderingVisitor;
import org.junit.jupiter.engine.discovery.DefaultMethodDescriptor;
import org.junit.jupiter.engine.discovery.DefaultMethodOrdererContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;

class MethodOrderingVisitor
extends AbstractOrderingVisitor {
    private final JupiterConfiguration configuration;
    private final DiscoveryIssueReporter.Condition<MethodBasedTestDescriptor> noOrderAnnotation;
    private final UnaryOperator<List<TestDescriptor>> methodsBeforeNestedClassesOrderer;

    MethodOrderingVisitor(JupiterConfiguration configuration, DiscoveryIssueReporter issueReporter) {
        super(issueReporter);
        this.configuration = configuration;
        this.noOrderAnnotation = issueReporter.createReportingCondition(testDescriptor -> !AnnotationSupport.isAnnotated(testDescriptor.getTestMethod(), Order.class), testDescriptor -> {
            String message = "Ineffective @Order annotation on method '%s'. It will not be applied because MethodOrderer.OrderAnnotation is not in use. Note that the annotation may be either directly present or meta-present on the method.".formatted(testDescriptor.getTestMethod().toGenericString());
            return DiscoveryIssue.builder(DiscoveryIssue.Severity.INFO, message).source(testDescriptor.getSource()).build();
        });
        this.methodsBeforeNestedClassesOrderer = MethodOrderingVisitor.createMethodsBeforeNestedClassesOrderer();
    }

    @Override
    public void visit(TestDescriptor testDescriptor) {
        this.doWithMatchingDescriptor(ClassBasedTestDescriptor.class, testDescriptor, descriptor -> this.orderContainedMethods((ClassBasedTestDescriptor)descriptor, descriptor.getTestClass()), descriptor -> "Failed to order methods for " + String.valueOf(descriptor.getTestClass()));
    }

    @Override
    protected boolean shouldNonMatchingDescriptorsComeBeforeOrderedOnes() {
        return false;
    }

    private void orderContainedMethods(ClassBasedTestDescriptor classBasedTestDescriptor, Class<?> testClass) {
        Optional<MethodOrderer> methodOrderer = AnnotationSupport.findAnnotation(testClass, TestMethodOrder.class).map(TestMethodOrder::value).map(x$0 -> (MethodOrderer)ReflectionSupport.newInstance(x$0, new Object[0])).or(this.configuration::getDefaultTestMethodOrderer);
        this.orderContainedMethods(classBasedTestDescriptor, testClass, methodOrderer);
    }

    private void orderContainedMethods(ClassBasedTestDescriptor classBasedTestDescriptor, Class<?> testClass, Optional<MethodOrderer> methodOrderer) {
        AbstractOrderingVisitor.DescriptorWrapperOrderer<?, DefaultMethodDescriptor> descriptorWrapperOrderer = this.createDescriptorWrapperOrderer(testClass, methodOrderer);
        this.orderChildrenTestDescriptors(classBasedTestDescriptor, MethodBasedTestDescriptor.class, this.toValidationAction(methodOrderer), DefaultMethodDescriptor::new, descriptorWrapperOrderer);
        if (methodOrderer.isEmpty()) {
            classBasedTestDescriptor.orderChildren(this.methodsBeforeNestedClassesOrderer);
        }
        methodOrderer.flatMap(it -> it.getDefaultExecutionMode().map(JupiterTestDescriptor::toExecutionMode)).ifPresent(classBasedTestDescriptor::setDefaultChildExecutionMode);
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<?, DefaultMethodDescriptor> createDescriptorWrapperOrderer(Class<?> testClass, Optional<MethodOrderer> methodOrderer) {
        return methodOrderer.map(it -> this.createDescriptorWrapperOrderer(testClass, (MethodOrderer)it)).orElseGet(AbstractOrderingVisitor.DescriptorWrapperOrderer::noop);
    }

    private AbstractOrderingVisitor.DescriptorWrapperOrderer<?, DefaultMethodDescriptor> createDescriptorWrapperOrderer(Class<?> testClass, MethodOrderer methodOrderer) {
        Consumer orderingAction = methodDescriptors -> methodOrderer.orderMethods(new DefaultMethodOrdererContext(testClass, (List<? extends MethodDescriptor>)methodDescriptors, this.configuration));
        AbstractOrderingVisitor.MessageGenerator descriptorsAddedMessageGenerator = number -> "MethodOrderer [%s] added %s MethodDescriptor(s) for test class [%s] which will be ignored.".formatted(methodOrderer.getClass().getName(), number, testClass.getName());
        AbstractOrderingVisitor.MessageGenerator descriptorsRemovedMessageGenerator = number -> "MethodOrderer [%s] removed %s MethodDescriptor(s) for test class [%s] which will be retained with arbitrary ordering.".formatted(methodOrderer.getClass().getName(), number, testClass.getName());
        return new AbstractOrderingVisitor.DescriptorWrapperOrderer(methodOrderer, orderingAction, descriptorsAddedMessageGenerator, descriptorsRemovedMessageGenerator);
    }

    private Optional<Consumer<MethodBasedTestDescriptor>> toValidationAction(Optional<MethodOrderer> methodOrderer) {
        if (methodOrderer.orElse(null) instanceof MethodOrderer.OrderAnnotation) {
            return Optional.empty();
        }
        return Optional.of(this.noOrderAnnotation::check);
    }

    private static UnaryOperator<List<TestDescriptor>> createMethodsBeforeNestedClassesOrderer() {
        Comparator<Object> methodsFirst = Comparator.comparing(MethodBasedTestDescriptor.class::isInstance).reversed();
        return children -> {
            children.sort(methodsFirst);
            return children;
        };
    }
}

