/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.Deque;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.annotation.Contract;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.opentest4j.AssertionFailedError;

class AssertionUtils {
    private AssertionUtils() {
    }

    @Contract(value=" -> fail")
    static void fail() {
        throw new AssertionFailedError();
    }

    @Contract(value="_ -> fail")
    static void fail(@Nullable String message) {
        throw new AssertionFailedError(message);
    }

    @Contract(value="_, _ -> fail")
    static void fail(@Nullable String message, @Nullable Throwable cause) {
        throw new AssertionFailedError(message, cause);
    }

    @Contract(value="_ -> fail")
    static void fail(@Nullable Throwable cause) {
        throw new AssertionFailedError(null, cause);
    }

    @Contract(value="_ -> fail")
    static void fail(Supplier<@Nullable String> messageSupplier) {
        throw new AssertionFailedError(AssertionUtils.nullSafeGet(messageSupplier));
    }

    static @Nullable String nullSafeGet(@Nullable Supplier<@Nullable String> messageSupplier) {
        return messageSupplier != null ? messageSupplier.get() : null;
    }

    static String getCanonicalName(Class<?> clazz) {
        try {
            String canonicalName = clazz.getCanonicalName();
            return canonicalName != null ? canonicalName : clazz.getName();
        }
        catch (Throwable t) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(t);
            return clazz.getName();
        }
    }

    static String formatIndexes(@Nullable Deque<Integer> indexes) {
        if (indexes == null || indexes.isEmpty()) {
            return "";
        }
        String indexesString = indexes.stream().map(Object::toString).collect(Collectors.joining("][", "[", "]"));
        return " at index " + indexesString;
    }

    static boolean floatsAreEqual(float value1, float value2, float delta) {
        AssertionUtils.assertValidDelta(delta);
        return AssertionUtils.floatsAreEqual(value1, value2) || Math.abs(value1 - value2) <= delta;
    }

    static void assertValidDelta(float delta) {
        if (Float.isNaN(delta) || (double)delta < 0.0) {
            AssertionUtils.failIllegalDelta(String.valueOf(delta));
        }
    }

    static void assertValidDelta(double delta) {
        if (Double.isNaN(delta) || delta < 0.0) {
            AssertionUtils.failIllegalDelta(String.valueOf(delta));
        }
    }

    static boolean floatsAreEqual(float value1, float value2) {
        return Float.floatToIntBits(value1) == Float.floatToIntBits(value2);
    }

    static boolean doublesAreEqual(double value1, double value2, double delta) {
        AssertionUtils.assertValidDelta(delta);
        return AssertionUtils.doublesAreEqual(value1, value2) || Math.abs(value1 - value2) <= delta;
    }

    static boolean doublesAreEqual(double value1, double value2) {
        return Double.doubleToLongBits(value1) == Double.doubleToLongBits(value2);
    }

    static boolean objectsAreEqual(@Nullable Object obj1, @Nullable Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    private static void failIllegalDelta(String delta) {
        AssertionUtils.fail("positive delta expected but was: <" + delta + ">");
    }
}

