/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.legacy.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Clock;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.reporting.legacy.xml.XmlReportData;
import org.junit.platform.reporting.legacy.xml.XmlReportWriter;

@API(status=API.Status.STABLE, since="1.7")
public class LegacyXmlReportGeneratingListener
implements TestExecutionListener {
    private final Path reportsDir;
    private final PrintWriter out;
    private final Clock clock;
    private @Nullable XmlReportData reportData;

    public LegacyXmlReportGeneratingListener(Path reportsDir, PrintWriter out) {
        this(reportsDir, out, Clock.systemDefaultZone());
    }

    LegacyXmlReportGeneratingListener(String reportsDir, PrintWriter out, Clock clock) {
        this(Path.of(reportsDir, new String[0]), out, clock);
    }

    private LegacyXmlReportGeneratingListener(Path reportsDir, PrintWriter out, Clock clock) {
        this.reportsDir = reportsDir;
        this.out = out;
        this.clock = clock;
    }

    @Override
    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.reportData = new XmlReportData(testPlan, this.clock);
        try {
            Files.createDirectories(this.reportsDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.printException("Could not create reports directory: " + String.valueOf(this.reportsDir), e);
        }
    }

    @Override
    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.reportData = null;
    }

    @Override
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.requiredReportData().markSkipped(testIdentifier, reason);
        this.writeXmlReportInCaseOfRoot(testIdentifier);
    }

    @Override
    public void executionStarted(TestIdentifier testIdentifier) {
        this.requiredReportData().markStarted(testIdentifier);
    }

    @Override
    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        this.requiredReportData().addReportEntry(testIdentifier, entry);
    }

    @Override
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult result) {
        this.requiredReportData().markFinished(testIdentifier, result);
        this.writeXmlReportInCaseOfRoot(testIdentifier);
    }

    private void writeXmlReportInCaseOfRoot(TestIdentifier testIdentifier) {
        if (this.isRoot(testIdentifier)) {
            String rootName = testIdentifier.getUniqueIdObject().getSegments().get(0).getValue();
            this.writeXmlReportSafely(testIdentifier, rootName);
        }
    }

    private void writeXmlReportSafely(TestIdentifier testIdentifier, String rootName) {
        Path xmlFile = this.reportsDir.resolve("TEST-" + rootName + ".xml");
        try (BufferedWriter fileWriter = Files.newBufferedWriter(xmlFile, new OpenOption[0]);){
            new XmlReportWriter(this.requiredReportData()).writeXmlReport(testIdentifier, fileWriter);
        }
        catch (IOException | XMLStreamException e) {
            this.printException("Could not write XML report: " + String.valueOf(xmlFile), e);
        }
    }

    private XmlReportData requiredReportData() {
        return Objects.requireNonNull(this.reportData);
    }

    private boolean isRoot(TestIdentifier testIdentifier) {
        return testIdentifier.getParentIdObject().isEmpty();
    }

    private void printException(String message, Exception exception) {
        this.out.println(message);
        exception.printStackTrace(this.out);
    }
}

