/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.listeners;

import java.util.Objects;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.MutableTestExecutionSummary;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

@API(status=API.Status.MAINTAINED, since="1.0")
public class SummaryGeneratingListener
implements TestExecutionListener {
    private @Nullable TestPlan testPlan;
    private @Nullable MutableTestExecutionSummary summary;

    public TestExecutionSummary getSummary() {
        return this.getMutableSummary();
    }

    private MutableTestExecutionSummary getMutableSummary() {
        return Preconditions.notNull(this.summary, "No tests have yet been executed");
    }

    @Override
    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = testPlan;
        this.summary = new MutableTestExecutionSummary(testPlan);
    }

    @Override
    public void testPlanExecutionFinished(TestPlan testPlan) {
        MutableTestExecutionSummary summary = this.getMutableSummary();
        summary.timeFinished = System.currentTimeMillis();
        summary.timeFinishedNanos = System.nanoTime();
    }

    @Override
    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        MutableTestExecutionSummary summary = this.getMutableSummary();
        if (testIdentifier.isContainer()) {
            summary.containersFound.incrementAndGet();
        }
        if (testIdentifier.isTest()) {
            summary.testsFound.incrementAndGet();
        }
    }

    @Override
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        TestPlan testPlan = Objects.requireNonNull(this.testPlan);
        long skippedContainers = Stream.concat(Stream.of(testIdentifier), testPlan.getDescendants(testIdentifier).stream()).filter(TestIdentifier::isContainer).count();
        long skippedTests = Stream.concat(Stream.of(testIdentifier), testPlan.getDescendants(testIdentifier).stream()).filter(TestIdentifier::isTest).count();
        MutableTestExecutionSummary summary = this.getMutableSummary();
        summary.containersSkipped.addAndGet(skippedContainers);
        summary.testsSkipped.addAndGet(skippedTests);
    }

    @Override
    public void executionStarted(TestIdentifier testIdentifier) {
        MutableTestExecutionSummary summary = this.getMutableSummary();
        if (testIdentifier.isContainer()) {
            summary.containersStarted.incrementAndGet();
        }
        if (testIdentifier.isTest()) {
            summary.testsStarted.incrementAndGet();
        }
    }

    @Override
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        MutableTestExecutionSummary summary = this.getMutableSummary();
        switch (testExecutionResult.getStatus()) {
            case SUCCESSFUL: {
                if (testIdentifier.isContainer()) {
                    summary.containersSucceeded.incrementAndGet();
                }
                if (!testIdentifier.isTest()) break;
                summary.testsSucceeded.incrementAndGet();
                break;
            }
            case ABORTED: {
                if (testIdentifier.isContainer()) {
                    summary.containersAborted.incrementAndGet();
                }
                if (!testIdentifier.isTest()) break;
                summary.testsAborted.incrementAndGet();
                break;
            }
            case FAILED: {
                if (testIdentifier.isContainer()) {
                    summary.containersFailed.incrementAndGet();
                }
                if (testIdentifier.isTest()) {
                    summary.testsFailed.incrementAndGet();
                }
                testExecutionResult.getThrowable().ifPresent(throwable -> summary.addFailure(testIdentifier, (Throwable)throwable));
                break;
            }
            default: {
                throw new PreconditionViolationException("Unsupported execution status:" + String.valueOf((Object)testExecutionResult.getStatus()));
            }
        }
    }
}

