/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.ServiceLoaderUtils;

class ServiceLoaderRegistry {
    ServiceLoaderRegistry() {
    }

    static <T> Iterable<T> load(Class<T> type) {
        return ServiceLoaderRegistry.load(type, __ -> true, instances -> ServiceLoaderRegistry.logLoadedInstances(type, instances, null));
    }

    static <T> Iterable<T> load(Class<T> type, Predicate<String> classNameFilter) {
        ArrayList exclusions = new ArrayList();
        Predicate<String> collectingClassNameFilter = className -> {
            boolean included = classNameFilter.test((String)className);
            if (!included) {
                exclusions.add(className);
            }
            return included;
        };
        return ServiceLoaderRegistry.load(type, collectingClassNameFilter, instances -> ServiceLoaderRegistry.logLoadedInstances(type, instances, exclusions));
    }

    private static <T> String logLoadedInstances(Class<T> type, List<T> instances, @Nullable List<String> exclusions) {
        String typeName = type.getSimpleName();
        if (exclusions == null) {
            return "Loaded %s instances: %s".formatted(typeName, instances);
        }
        return "Loaded %s instances: %s (excluded classes: %s)".formatted(typeName, instances, exclusions);
    }

    private static <T> List<T> load(Class<T> type, Predicate<String> classNameFilter, Function<List<T>, String> logMessageSupplier) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(type, ClassLoaderUtils.getDefaultClassLoader());
        Predicate<Class> providerPredicate = clazz -> classNameFilter.test(clazz.getName());
        List instances = ServiceLoaderUtils.filter(serviceLoader, providerPredicate).toList();
        ServiceLoaderRegistry.getLogger().config(() -> (String)logMessageSupplier.apply(instances));
        return instances;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ServiceLoaderRegistry.class);
    }
}

