/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.engine.ConfigurationParameters;

enum LauncherPhase {
    DISCOVERY,
    EXECUTION;

    private static final Logger logger;

    static Optional<LauncherPhase> getDiscoveryIssueFailurePhase(ConfigurationParameters configurationParameters) {
        Function<String, @Nullable LauncherPhase> stringLauncherPhaseFunction = value -> {
            try {
                return LauncherPhase.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                logger.warn(() -> "Ignoring invalid LauncherPhase '%s' set via the '%s' configuration parameter.".formatted(value, "junit.platform.discovery.issue.failure.phase"));
                return null;
            }
        };
        return configurationParameters.get("junit.platform.discovery.issue.failure.phase", stringLauncherPhaseFunction);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    static {
        logger = LoggerFactory.getLogger(LauncherPhase.class);
    }
}

