/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.core.DiscoveryIssueException;

class DiscoveryIssueNotifier {
    static final DiscoveryIssueNotifier NO_ISSUES = new DiscoveryIssueNotifier(List.of(), List.of(), List.of());
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryIssueNotifier.class);
    private final List<DiscoveryIssue> allIssues;
    private final List<DiscoveryIssue> criticalIssues;
    private final List<DiscoveryIssue> nonCriticalIssues;

    static DiscoveryIssueNotifier from(DiscoveryIssue.Severity criticalSeverity, List<DiscoveryIssue> issues) {
        Map<Boolean, List<DiscoveryIssue>> issuesByCriticality = DiscoveryIssueNotifier.partitionByCriticality(criticalSeverity, issues);
        List<DiscoveryIssue> criticalIssues = issuesByCriticality.get(true);
        List<DiscoveryIssue> nonCriticalIssues = issuesByCriticality.get(false);
        return new DiscoveryIssueNotifier(issues, criticalIssues, nonCriticalIssues);
    }

    private static Map<Boolean, List<DiscoveryIssue>> partitionByCriticality(DiscoveryIssue.Severity criticalSeverity, List<DiscoveryIssue> issues) {
        return issues.stream().sorted(Comparator.comparing(DiscoveryIssue::severity).reversed()).collect(Collectors.partitioningBy(issue -> issue.severity().compareTo(criticalSeverity) >= 0, Collectors.toUnmodifiableList()));
    }

    private DiscoveryIssueNotifier(List<DiscoveryIssue> allIssues, List<DiscoveryIssue> criticalIssues, List<DiscoveryIssue> nonCriticalIssues) {
        this.allIssues = List.copyOf(allIssues);
        this.criticalIssues = List.copyOf(criticalIssues);
        this.nonCriticalIssues = List.copyOf(nonCriticalIssues);
    }

    List<DiscoveryIssue> getAllIssues() {
        return this.allIssues;
    }

    boolean hasCriticalIssues() {
        return !this.criticalIssues.isEmpty();
    }

    void logCriticalIssues(TestEngine testEngine) {
        this.logIssues(testEngine, this.criticalIssues, "critical");
    }

    void logNonCriticalIssues(TestEngine testEngine) {
        this.logIssues(testEngine, this.nonCriticalIssues, "non-critical");
    }

    @Nullable DiscoveryIssueException createExceptionForCriticalIssues(TestEngine testEngine) {
        if (this.criticalIssues.isEmpty()) {
            return null;
        }
        String message = DiscoveryIssueNotifier.formatMessage(testEngine, this.criticalIssues, "critical");
        return new DiscoveryIssueException(message);
    }

    private void logIssues(TestEngine testEngine, List<DiscoveryIssue> issues, String adjective) {
        if (!issues.isEmpty()) {
            DiscoveryIssue.Severity maxSeverity = issues.get(0).severity();
            DiscoveryIssueNotifier.logger(maxSeverity).accept(() -> DiscoveryIssueNotifier.formatMessage(testEngine, issues, adjective));
        }
    }

    private static Consumer<Supplier<String>> logger(DiscoveryIssue.Severity severity) {
        return switch (severity) {
            default -> throw new IncompatibleClassChangeError();
            case DiscoveryIssue.Severity.INFO -> logger::info;
            case DiscoveryIssue.Severity.WARNING -> logger::warn;
            case DiscoveryIssue.Severity.ERROR -> logger::error;
        };
    }

    private static String formatMessage(TestEngine testEngine, List<DiscoveryIssue> issues, String adjective) {
        Preconditions.notNull(testEngine, "testEngine must not be null");
        Preconditions.notNull(issues, "issues must not be null");
        Preconditions.notEmpty(issues, "issues must not be empty");
        String engineId = testEngine.getId();
        StringBuilder message = new StringBuilder();
        message.append("TestEngine with ID '").append(engineId).append("' encountered ");
        if (issues.size() == 1) {
            message.append("a ").append(adjective).append(" issue");
        } else {
            message.append(issues.size()).append(' ').append(adjective).append(" issues");
        }
        message.append(" during test discovery:");
        for (int i2 = 0; i2 < issues.size(); ++i2) {
            DiscoveryIssue issue = issues.get(i2);
            message.append("\n\n(").append(i2 + 1).append(") [").append((Object)issue.severity()).append("] ").append(issue.message());
            issue.source().ifPresent(source -> {
                message.append("\n    Source: ").append(source);
                if (source instanceof MethodSource) {
                    MethodSource methodSource = (MethodSource)source;
                    DiscoveryIssueNotifier.appendIdeCompatibleLink(message, methodSource.getClassName(), methodSource.getMethodName());
                } else if (source instanceof ClassSource) {
                    ClassSource classSource = (ClassSource)source;
                    DiscoveryIssueNotifier.appendIdeCompatibleLink(message, classSource.getClassName(), "<no-method>");
                }
            });
            issue.cause().ifPresent(t -> message.append("\n    Cause: ").append(ExceptionUtils.readStackTrace(t)));
        }
        return message.toString();
    }

    private static void appendIdeCompatibleLink(StringBuilder message, String className, String methodName) {
        message.append("\n            at ").append(className).append(".").append(methodName).append("(SourceFile:0)");
    }
}

