/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.EXPERIMENTAL, since="6.0")
public class Namespace {
    public static final Namespace GLOBAL = Namespace.create(new Object());
    private final List<Object> parts;

    public static Namespace create(Object ... parts) {
        Preconditions.notEmpty(parts, "parts array must not be null or empty");
        Preconditions.containsNoNullElements(parts, "individual parts must not be null");
        return new Namespace(List.of(parts));
    }

    public static Namespace create(List<Object> objects) {
        Preconditions.notEmpty(objects, "objects list must not be null or empty");
        Preconditions.containsNoNullElements(objects, "individual objects must not be null");
        return new Namespace(objects);
    }

    private Namespace(List<Object> parts) {
        this.parts = List.copyOf(parts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Namespace that = (Namespace)o;
        return this.parts.equals(that.parts);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }

    public Namespace append(Object ... parts) {
        Preconditions.notEmpty(parts, "parts array must not be null or empty");
        Preconditions.containsNoNullElements(parts, "individual parts must not be null");
        ArrayList<Object> newParts = new ArrayList<Object>(this.parts.size() + parts.length);
        newParts.addAll(this.parts);
        Collections.addAll(newParts, parts);
        return new Namespace(newParts);
    }
}

