/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.support.descriptor.FilePosition;
import org.junit.platform.engine.support.descriptor.FileSystemSource;

@API(status=API.Status.STABLE, since="1.0")
public class FileSource
implements FileSystemSource {
    private static final long serialVersionUID = 1L;
    private final File file;
    private final @Nullable FilePosition filePosition;

    public static FileSource from(File file) {
        return new FileSource(file);
    }

    public static FileSource from(File file, @Nullable FilePosition filePosition) {
        return new FileSource(file, filePosition);
    }

    private FileSource(File file) {
        this(file, null);
    }

    private FileSource(File file, @Nullable FilePosition filePosition) {
        Preconditions.notNull(file, "file must not be null");
        try {
            this.file = file.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new JUnitException("Failed to retrieve canonical path for file: " + String.valueOf(file), ex);
        }
        this.filePosition = filePosition;
    }

    @Override
    public final URI getUri() {
        return this.getFile().toURI();
    }

    @Override
    public final File getFile() {
        return this.file;
    }

    public final Optional<FilePosition> getPosition() {
        return Optional.ofNullable(this.filePosition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSource that = (FileSource)o;
        return Objects.equals(this.file, that.file) && Objects.equals(this.filePosition, that.filePosition);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.filePosition);
    }

    public String toString() {
        return new ToStringBuilder(this).append("file", this.file).append("filePosition", this.filePosition).toString();
    }
}

