/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ResourceUtils;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.FilePosition;

@API(status=API.Status.STABLE, since="1.0")
public class ClasspathResourceSource
implements TestSource {
    private static final long serialVersionUID = 1L;
    public static final String CLASSPATH_SCHEME = "classpath";
    private final String classpathResourceName;
    private final @Nullable FilePosition filePosition;

    public static ClasspathResourceSource from(String classpathResourceName) {
        return new ClasspathResourceSource(classpathResourceName);
    }

    public static ClasspathResourceSource from(String classpathResourceName, @Nullable FilePosition filePosition) {
        return new ClasspathResourceSource(classpathResourceName, filePosition);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public static ClasspathResourceSource from(URI uri) {
        Preconditions.notNull(uri, "URI must not be null");
        Preconditions.condition(CLASSPATH_SCHEME.equals(uri.getScheme()), () -> "URI [" + String.valueOf(uri) + "] must have [classpath] scheme");
        String classpathResource = ResourceUtils.stripQueryComponent(uri).getPath();
        FilePosition filePosition = FilePosition.fromQuery(uri.getQuery()).orElse(null);
        return ClasspathResourceSource.from(classpathResource, filePosition);
    }

    private ClasspathResourceSource(String classpathResourceName) {
        this(classpathResourceName, null);
    }

    private ClasspathResourceSource(String classpathResourceName, @Nullable FilePosition filePosition) {
        Preconditions.notBlank(classpathResourceName, "Classpath resource name must not be null or blank");
        boolean startsWithSlash = classpathResourceName.startsWith("/");
        this.classpathResourceName = startsWithSlash ? classpathResourceName.substring(1) : classpathResourceName;
        this.filePosition = filePosition;
    }

    public String getClasspathResourceName() {
        return this.classpathResourceName;
    }

    public final Optional<FilePosition> getPosition() {
        return Optional.ofNullable(this.filePosition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClasspathResourceSource that = (ClasspathResourceSource)o;
        return Objects.equals(this.classpathResourceName, that.classpathResourceName) && Objects.equals(this.filePosition, that.filePosition);
    }

    public int hashCode() {
        return Objects.hash(this.classpathResourceName, this.filePosition);
    }

    public String toString() {
        return new ToStringBuilder(this).append("classpathResourceName", this.classpathResourceName).append("filePosition", this.filePosition).toString();
    }
}

