/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.discovery.PackageNameFilter;

class IncludePackageNameFilter
implements PackageNameFilter {
    private final List<String> packageNames;
    private final String patternDescription;

    IncludePackageNameFilter(String ... packageNames) {
        Preconditions.notEmpty(packageNames, "packageNames array must not be null or empty");
        Preconditions.containsNoNullElements(packageNames, "packageNames array must not contain null elements");
        this.packageNames = Arrays.asList(packageNames);
        this.patternDescription = Arrays.stream(packageNames).collect(Collectors.joining("' OR '", "'", "'"));
    }

    @Override
    public FilterResult apply(String packageName) {
        return this.findMatchingName(packageName).map(matchedName -> FilterResult.included(this.formatInclusionReason(packageName, (String)matchedName))).orElseGet(() -> FilterResult.excluded(this.formatExclusionReason(packageName)));
    }

    private String formatInclusionReason(String packageName, String matchedName) {
        return "Package name [%s] matches included name: '%s'".formatted(packageName, matchedName);
    }

    private String formatExclusionReason(String packageName) {
        return "Package name [%s] does not match any included names: %s".formatted(packageName, this.patternDescription);
    }

    @Override
    public Predicate<String> toPredicate() {
        return packageName -> this.findMatchingName((String)packageName).isPresent();
    }

    private Optional<String> findMatchingName(String packageName) {
        return this.packageNames.stream().filter(name -> name.equals(packageName) || packageName.startsWith(name + ".")).findAny();
    }

    public String toString() {
        return "%s that includes packages whose names are either equal to or start with one of the following: %s".formatted(this.getClass().getSimpleName(), this.patternDescription);
    }
}

